<?php

namespace optsoapsdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgentResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AgentResponse
 * @subpackage Structs
 */
class AgentResponse extends AbstractStructBase
{
    /**
     * The Successfull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Successfull;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The OptAgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptAgentID;
    /**
     * The OptPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptPassword;
    /**
     * Constructor method for AgentResponse
     * @uses AgentResponse::setSuccessfull()
     * @uses AgentResponse::setMessage()
     * @uses AgentResponse::setOptAgentID()
     * @uses AgentResponse::setOptPassword()
     * @param bool $successfull
     * @param string $message
     * @param string $optAgentID
     * @param string $optPassword
     */
    public function __construct($successfull = null, $message = null, $optAgentID = null, $optPassword = null)
    {
        $this
            ->setSuccessfull($successfull)
            ->setMessage($message)
            ->setOptAgentID($optAgentID)
            ->setOptPassword($optPassword);
    }
    /**
     * Get Successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->Successfull;
    }
    /**
     * Set Successfull value
     * @param bool $successfull
     * @return \optsoapsdk\StructType\AgentResponse
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->Successfull = $successfull;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \optsoapsdk\StructType\AgentResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get OptAgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptAgentID()
    {
        return isset($this->OptAgentID) ? $this->OptAgentID : null;
    }
    /**
     * Set OptAgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optAgentID
     * @return \optsoapsdk\StructType\AgentResponse
     */
    public function setOptAgentID($optAgentID = null)
    {
        // validation for constraint: string
        if (!is_null($optAgentID) && !is_string($optAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optAgentID, true), gettype($optAgentID)), __LINE__);
        }
        if (is_null($optAgentID) || (is_array($optAgentID) && empty($optAgentID))) {
            unset($this->OptAgentID);
        } else {
            $this->OptAgentID = $optAgentID;
        }
        return $this;
    }
    /**
     * Get OptPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptPassword()
    {
        return isset($this->OptPassword) ? $this->OptPassword : null;
    }
    /**
     * Set OptPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optPassword
     * @return \optsoapsdk\StructType\AgentResponse
     */
    public function setOptPassword($optPassword = null)
    {
        // validation for constraint: string
        if (!is_null($optPassword) && !is_string($optPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optPassword, true), gettype($optPassword)), __LINE__);
        }
        if (is_null($optPassword) || (is_array($optPassword) && empty($optPassword))) {
            unset($this->OptPassword);
        } else {
            $this->OptPassword = $optPassword;
        }
        return $this;
    }
}
