<?php

namespace optsoapsdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplicationDetail
 * @subpackage Structs
 */
class ApplicationDetail extends AbstractStructBase
{
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * The SubmittedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubmittedDate;
    /**
     * The ReceivedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceivedDate;
    /**
     * The Applicant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Applicant;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The SourceOfReferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceOfReferral;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The ApplicationTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationTitle;
    /**
     * The LeadCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadCode;
    /**
     * The LeadLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadLevel;
    /**
     * The PurchaseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaseDate;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The LeadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadSource;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $County;
    /**
     * The Zip5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip5;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The CellPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CellPhone;
    /**
     * The WorkPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPhone;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The AgentOptID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentOptID;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Carrier;
    /**
     * The ContractIssue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractIssue;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Product;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The ProductSubtype
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductSubtype;
    /**
     * The SaleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleType;
    /**
     * The PurchtoProtectMort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PurchtoProtectMort;
    /**
     * The FaceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FaceAmount;
    /**
     * The APV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APV;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Percentage;
    /**
     * The AgentSplit2OptID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentSplit2OptID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusDate;
    /**
     * The eApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $eApp;
    /**
     * The FirstTimeCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FirstTimeCarrier;
    /**
     * The LeadStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadStatus;
    /**
     * The LastMaintainDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastMaintainDate;
    /**
     * Constructor method for ApplicationDetail
     * @uses ApplicationDetail::setResponseMessage()
     * @uses ApplicationDetail::setSubmittedDate()
     * @uses ApplicationDetail::setReceivedDate()
     * @uses ApplicationDetail::setApplicant()
     * @uses ApplicationDetail::setFirstName()
     * @uses ApplicationDetail::setLastName()
     * @uses ApplicationDetail::setSource()
     * @uses ApplicationDetail::setSourceOfReferral()
     * @uses ApplicationDetail::setType()
     * @uses ApplicationDetail::setApplicationTitle()
     * @uses ApplicationDetail::setLeadCode()
     * @uses ApplicationDetail::setLeadLevel()
     * @uses ApplicationDetail::setPurchaseDate()
     * @uses ApplicationDetail::setPrice()
     * @uses ApplicationDetail::setLeadSource()
     * @uses ApplicationDetail::setAddress()
     * @uses ApplicationDetail::setCity()
     * @uses ApplicationDetail::setState()
     * @uses ApplicationDetail::setZip()
     * @uses ApplicationDetail::setCounty()
     * @uses ApplicationDetail::setZip5()
     * @uses ApplicationDetail::setHomePhone()
     * @uses ApplicationDetail::setCellPhone()
     * @uses ApplicationDetail::setWorkPhone()
     * @uses ApplicationDetail::setAge()
     * @uses ApplicationDetail::setBirthDate()
     * @uses ApplicationDetail::setEmail()
     * @uses ApplicationDetail::setAgentOptID()
     * @uses ApplicationDetail::setCarrier()
     * @uses ApplicationDetail::setContractIssue()
     * @uses ApplicationDetail::setProduct()
     * @uses ApplicationDetail::setProductType()
     * @uses ApplicationDetail::setProductSubtype()
     * @uses ApplicationDetail::setSaleType()
     * @uses ApplicationDetail::setPurchtoProtectMort()
     * @uses ApplicationDetail::setFaceAmount()
     * @uses ApplicationDetail::setAPV()
     * @uses ApplicationDetail::setPercentage()
     * @uses ApplicationDetail::setAgentSplit2OptID()
     * @uses ApplicationDetail::setStatus()
     * @uses ApplicationDetail::setStatusDate()
     * @uses ApplicationDetail::setEApp()
     * @uses ApplicationDetail::setFirstTimeCarrier()
     * @uses ApplicationDetail::setLeadStatus()
     * @uses ApplicationDetail::setLastMaintainDate()
     * @param string $responseMessage
     * @param string $submittedDate
     * @param string $receivedDate
     * @param string $applicant
     * @param string $firstName
     * @param string $lastName
     * @param string $source
     * @param string $sourceOfReferral
     * @param string $type
     * @param string $applicationTitle
     * @param string $leadCode
     * @param string $leadLevel
     * @param string $purchaseDate
     * @param float $price
     * @param string $leadSource
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $county
     * @param string $zip5
     * @param string $homePhone
     * @param string $cellPhone
     * @param string $workPhone
     * @param int $age
     * @param string $birthDate
     * @param string $email
     * @param string $agentOptID
     * @param string $carrier
     * @param string $contractIssue
     * @param string $product
     * @param string $productType
     * @param string $productSubtype
     * @param string $saleType
     * @param bool $purchtoProtectMort
     * @param float $faceAmount
     * @param float $aPV
     * @param string $percentage
     * @param string $agentSplit2OptID
     * @param string $status
     * @param string $statusDate
     * @param int $eApp
     * @param bool $firstTimeCarrier
     * @param string $leadStatus
     * @param string $lastMaintainDate
     */
    public function __construct($responseMessage = null, $submittedDate = null, $receivedDate = null, $applicant = null, $firstName = null, $lastName = null, $source = null, $sourceOfReferral = null, $type = null, $applicationTitle = null, $leadCode = null, $leadLevel = null, $purchaseDate = null, $price = null, $leadSource = null, $address = null, $city = null, $state = null, $zip = null, $county = null, $zip5 = null, $homePhone = null, $cellPhone = null, $workPhone = null, $age = null, $birthDate = null, $email = null, $agentOptID = null, $carrier = null, $contractIssue = null, $product = null, $productType = null, $productSubtype = null, $saleType = null, $purchtoProtectMort = null, $faceAmount = null, $aPV = null, $percentage = null, $agentSplit2OptID = null, $status = null, $statusDate = null, $eApp = null, $firstTimeCarrier = null, $leadStatus = null, $lastMaintainDate = null)
    {
        $this
            ->setResponseMessage($responseMessage)
            ->setSubmittedDate($submittedDate)
            ->setReceivedDate($receivedDate)
            ->setApplicant($applicant)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSource($source)
            ->setSourceOfReferral($sourceOfReferral)
            ->setType($type)
            ->setApplicationTitle($applicationTitle)
            ->setLeadCode($leadCode)
            ->setLeadLevel($leadLevel)
            ->setPurchaseDate($purchaseDate)
            ->setPrice($price)
            ->setLeadSource($leadSource)
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCounty($county)
            ->setZip5($zip5)
            ->setHomePhone($homePhone)
            ->setCellPhone($cellPhone)
            ->setWorkPhone($workPhone)
            ->setAge($age)
            ->setBirthDate($birthDate)
            ->setEmail($email)
            ->setAgentOptID($agentOptID)
            ->setCarrier($carrier)
            ->setContractIssue($contractIssue)
            ->setProduct($product)
            ->setProductType($productType)
            ->setProductSubtype($productSubtype)
            ->setSaleType($saleType)
            ->setPurchtoProtectMort($purchtoProtectMort)
            ->setFaceAmount($faceAmount)
            ->setAPV($aPV)
            ->setPercentage($percentage)
            ->setAgentSplit2OptID($agentSplit2OptID)
            ->setStatus($status)
            ->setStatusDate($statusDate)
            ->setEApp($eApp)
            ->setFirstTimeCarrier($firstTimeCarrier)
            ->setLeadStatus($leadStatus)
            ->setLastMaintainDate($lastMaintainDate);
    }
    /**
     * Get ResponseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->ResponseMessage) ? $this->ResponseMessage : null;
    }
    /**
     * Set ResponseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->ResponseMessage);
        } else {
            $this->ResponseMessage = $responseMessage;
        }
        return $this;
    }
    /**
     * Get SubmittedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubmittedDate()
    {
        return isset($this->SubmittedDate) ? $this->SubmittedDate : null;
    }
    /**
     * Set SubmittedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $submittedDate
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setSubmittedDate($submittedDate = null)
    {
        // validation for constraint: string
        if (!is_null($submittedDate) && !is_string($submittedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedDate, true), gettype($submittedDate)), __LINE__);
        }
        if (is_null($submittedDate) || (is_array($submittedDate) && empty($submittedDate))) {
            unset($this->SubmittedDate);
        } else {
            $this->SubmittedDate = $submittedDate;
        }
        return $this;
    }
    /**
     * Get ReceivedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceivedDate()
    {
        return isset($this->ReceivedDate) ? $this->ReceivedDate : null;
    }
    /**
     * Set ReceivedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receivedDate
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setReceivedDate($receivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($receivedDate) && !is_string($receivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedDate, true), gettype($receivedDate)), __LINE__);
        }
        if (is_null($receivedDate) || (is_array($receivedDate) && empty($receivedDate))) {
            unset($this->ReceivedDate);
        } else {
            $this->ReceivedDate = $receivedDate;
        }
        return $this;
    }
    /**
     * Get Applicant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicant()
    {
        return isset($this->Applicant) ? $this->Applicant : null;
    }
    /**
     * Set Applicant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicant
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setApplicant($applicant = null)
    {
        // validation for constraint: string
        if (!is_null($applicant) && !is_string($applicant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicant, true), gettype($applicant)), __LINE__);
        }
        if (is_null($applicant) || (is_array($applicant) && empty($applicant))) {
            unset($this->Applicant);
        } else {
            $this->Applicant = $applicant;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
    /**
     * Get SourceOfReferral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceOfReferral()
    {
        return isset($this->SourceOfReferral) ? $this->SourceOfReferral : null;
    }
    /**
     * Set SourceOfReferral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceOfReferral
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setSourceOfReferral($sourceOfReferral = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfReferral) && !is_string($sourceOfReferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOfReferral, true), gettype($sourceOfReferral)), __LINE__);
        }
        if (is_null($sourceOfReferral) || (is_array($sourceOfReferral) && empty($sourceOfReferral))) {
            unset($this->SourceOfReferral);
        } else {
            $this->SourceOfReferral = $sourceOfReferral;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get ApplicationTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationTitle()
    {
        return isset($this->ApplicationTitle) ? $this->ApplicationTitle : null;
    }
    /**
     * Set ApplicationTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationTitle
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setApplicationTitle($applicationTitle = null)
    {
        // validation for constraint: string
        if (!is_null($applicationTitle) && !is_string($applicationTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationTitle, true), gettype($applicationTitle)), __LINE__);
        }
        if (is_null($applicationTitle) || (is_array($applicationTitle) && empty($applicationTitle))) {
            unset($this->ApplicationTitle);
        } else {
            $this->ApplicationTitle = $applicationTitle;
        }
        return $this;
    }
    /**
     * Get LeadCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadCode()
    {
        return isset($this->LeadCode) ? $this->LeadCode : null;
    }
    /**
     * Set LeadCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadCode
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setLeadCode($leadCode = null)
    {
        // validation for constraint: string
        if (!is_null($leadCode) && !is_string($leadCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadCode, true), gettype($leadCode)), __LINE__);
        }
        if (is_null($leadCode) || (is_array($leadCode) && empty($leadCode))) {
            unset($this->LeadCode);
        } else {
            $this->LeadCode = $leadCode;
        }
        return $this;
    }
    /**
     * Get LeadLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadLevel()
    {
        return isset($this->LeadLevel) ? $this->LeadLevel : null;
    }
    /**
     * Set LeadLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadLevel
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setLeadLevel($leadLevel = null)
    {
        // validation for constraint: string
        if (!is_null($leadLevel) && !is_string($leadLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadLevel, true), gettype($leadLevel)), __LINE__);
        }
        if (is_null($leadLevel) || (is_array($leadLevel) && empty($leadLevel))) {
            unset($this->LeadLevel);
        } else {
            $this->LeadLevel = $leadLevel;
        }
        return $this;
    }
    /**
     * Get PurchaseDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return isset($this->PurchaseDate) ? $this->PurchaseDate : null;
    }
    /**
     * Set PurchaseDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaseDate
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDate) && !is_string($purchaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDate, true), gettype($purchaseDate)), __LINE__);
        }
        if (is_null($purchaseDate) || (is_array($purchaseDate) && empty($purchaseDate))) {
            unset($this->PurchaseDate);
        } else {
            $this->PurchaseDate = $purchaseDate;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get LeadSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadSource()
    {
        return isset($this->LeadSource) ? $this->LeadSource : null;
    }
    /**
     * Set LeadSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadSource
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setLeadSource($leadSource = null)
    {
        // validation for constraint: string
        if (!is_null($leadSource) && !is_string($leadSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadSource, true), gettype($leadSource)), __LINE__);
        }
        if (is_null($leadSource) || (is_array($leadSource) && empty($leadSource))) {
            unset($this->LeadSource);
        } else {
            $this->LeadSource = $leadSource;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->Zip) ? $this->Zip : null;
    }
    /**
     * Set Zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->Zip);
        } else {
            $this->Zip = $zip;
        }
        return $this;
    }
    /**
     * Get County value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCounty()
    {
        return isset($this->County) ? $this->County : null;
    }
    /**
     * Set County value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $county
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        if (is_null($county) || (is_array($county) && empty($county))) {
            unset($this->County);
        } else {
            $this->County = $county;
        }
        return $this;
    }
    /**
     * Get Zip5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip5()
    {
        return isset($this->Zip5) ? $this->Zip5 : null;
    }
    /**
     * Set Zip5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip5
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setZip5($zip5 = null)
    {
        // validation for constraint: string
        if (!is_null($zip5) && !is_string($zip5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip5, true), gettype($zip5)), __LINE__);
        }
        if (is_null($zip5) || (is_array($zip5) && empty($zip5))) {
            unset($this->Zip5);
        } else {
            $this->Zip5 = $zip5;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get CellPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellPhone()
    {
        return isset($this->CellPhone) ? $this->CellPhone : null;
    }
    /**
     * Set CellPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellPhone
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setCellPhone($cellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cellPhone) && !is_string($cellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cellPhone, true), gettype($cellPhone)), __LINE__);
        }
        if (is_null($cellPhone) || (is_array($cellPhone) && empty($cellPhone))) {
            unset($this->CellPhone);
        } else {
            $this->CellPhone = $cellPhone;
        }
        return $this;
    }
    /**
     * Get WorkPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPhone()
    {
        return isset($this->WorkPhone) ? $this->WorkPhone : null;
    }
    /**
     * Set WorkPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPhone
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        if (is_null($workPhone) || (is_array($workPhone) && empty($workPhone))) {
            unset($this->WorkPhone);
        } else {
            $this->WorkPhone = $workPhone;
        }
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get BirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->BirthDate) ? $this->BirthDate : null;
    }
    /**
     * Set BirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthDate
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->BirthDate);
        } else {
            $this->BirthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get AgentOptID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentOptID()
    {
        return isset($this->AgentOptID) ? $this->AgentOptID : null;
    }
    /**
     * Set AgentOptID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentOptID
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setAgentOptID($agentOptID = null)
    {
        // validation for constraint: string
        if (!is_null($agentOptID) && !is_string($agentOptID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentOptID, true), gettype($agentOptID)), __LINE__);
        }
        if (is_null($agentOptID) || (is_array($agentOptID) && empty($agentOptID))) {
            unset($this->AgentOptID);
        } else {
            $this->AgentOptID = $agentOptID;
        }
        return $this;
    }
    /**
     * Get Carrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrier()
    {
        return isset($this->Carrier) ? $this->Carrier : null;
    }
    /**
     * Set Carrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrier
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        if (is_null($carrier) || (is_array($carrier) && empty($carrier))) {
            unset($this->Carrier);
        } else {
            $this->Carrier = $carrier;
        }
        return $this;
    }
    /**
     * Get ContractIssue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractIssue()
    {
        return isset($this->ContractIssue) ? $this->ContractIssue : null;
    }
    /**
     * Set ContractIssue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractIssue
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setContractIssue($contractIssue = null)
    {
        // validation for constraint: string
        if (!is_null($contractIssue) && !is_string($contractIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractIssue, true), gettype($contractIssue)), __LINE__);
        }
        if (is_null($contractIssue) || (is_array($contractIssue) && empty($contractIssue))) {
            unset($this->ContractIssue);
        } else {
            $this->ContractIssue = $contractIssue;
        }
        return $this;
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $product
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productType
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get ProductSubtype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductSubtype()
    {
        return isset($this->ProductSubtype) ? $this->ProductSubtype : null;
    }
    /**
     * Set ProductSubtype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productSubtype
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setProductSubtype($productSubtype = null)
    {
        // validation for constraint: string
        if (!is_null($productSubtype) && !is_string($productSubtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSubtype, true), gettype($productSubtype)), __LINE__);
        }
        if (is_null($productSubtype) || (is_array($productSubtype) && empty($productSubtype))) {
            unset($this->ProductSubtype);
        } else {
            $this->ProductSubtype = $productSubtype;
        }
        return $this;
    }
    /**
     * Get SaleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleType()
    {
        return isset($this->SaleType) ? $this->SaleType : null;
    }
    /**
     * Set SaleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleType
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setSaleType($saleType = null)
    {
        // validation for constraint: string
        if (!is_null($saleType) && !is_string($saleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleType, true), gettype($saleType)), __LINE__);
        }
        if (is_null($saleType) || (is_array($saleType) && empty($saleType))) {
            unset($this->SaleType);
        } else {
            $this->SaleType = $saleType;
        }
        return $this;
    }
    /**
     * Get PurchtoProtectMort value
     * @return bool|null
     */
    public function getPurchtoProtectMort()
    {
        return $this->PurchtoProtectMort;
    }
    /**
     * Set PurchtoProtectMort value
     * @param bool $purchtoProtectMort
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setPurchtoProtectMort($purchtoProtectMort = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchtoProtectMort) && !is_bool($purchtoProtectMort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchtoProtectMort, true), gettype($purchtoProtectMort)), __LINE__);
        }
        $this->PurchtoProtectMort = $purchtoProtectMort;
        return $this;
    }
    /**
     * Get FaceAmount value
     * @return float|null
     */
    public function getFaceAmount()
    {
        return $this->FaceAmount;
    }
    /**
     * Set FaceAmount value
     * @param float $faceAmount
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setFaceAmount($faceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($faceAmount) && !(is_float($faceAmount) || is_numeric($faceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($faceAmount, true), gettype($faceAmount)), __LINE__);
        }
        $this->FaceAmount = $faceAmount;
        return $this;
    }
    /**
     * Get APV value
     * @return float|null
     */
    public function getAPV()
    {
        return $this->APV;
    }
    /**
     * Set APV value
     * @param float $aPV
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setAPV($aPV = null)
    {
        // validation for constraint: float
        if (!is_null($aPV) && !(is_float($aPV) || is_numeric($aPV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aPV, true), gettype($aPV)), __LINE__);
        }
        $this->APV = $aPV;
        return $this;
    }
    /**
     * Get Percentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPercentage()
    {
        return isset($this->Percentage) ? $this->Percentage : null;
    }
    /**
     * Set Percentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $percentage
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: string
        if (!is_null($percentage) && !is_string($percentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        if (is_null($percentage) || (is_array($percentage) && empty($percentage))) {
            unset($this->Percentage);
        } else {
            $this->Percentage = $percentage;
        }
        return $this;
    }
    /**
     * Get AgentSplit2OptID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentSplit2OptID()
    {
        return isset($this->AgentSplit2OptID) ? $this->AgentSplit2OptID : null;
    }
    /**
     * Set AgentSplit2OptID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentSplit2OptID
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setAgentSplit2OptID($agentSplit2OptID = null)
    {
        // validation for constraint: string
        if (!is_null($agentSplit2OptID) && !is_string($agentSplit2OptID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSplit2OptID, true), gettype($agentSplit2OptID)), __LINE__);
        }
        if (is_null($agentSplit2OptID) || (is_array($agentSplit2OptID) && empty($agentSplit2OptID))) {
            unset($this->AgentSplit2OptID);
        } else {
            $this->AgentSplit2OptID = $agentSplit2OptID;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusDate()
    {
        return isset($this->StatusDate) ? $this->StatusDate : null;
    }
    /**
     * Set StatusDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusDate
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        if (is_null($statusDate) || (is_array($statusDate) && empty($statusDate))) {
            unset($this->StatusDate);
        } else {
            $this->StatusDate = $statusDate;
        }
        return $this;
    }
    /**
     * Get eApp value
     * @return int|null
     */
    public function getEApp()
    {
        return $this->eApp;
    }
    /**
     * Set eApp value
     * @param int $eApp
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setEApp($eApp = null)
    {
        // validation for constraint: int
        if (!is_null($eApp) && !(is_int($eApp) || ctype_digit($eApp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eApp, true), gettype($eApp)), __LINE__);
        }
        $this->eApp = $eApp;
        return $this;
    }
    /**
     * Get FirstTimeCarrier value
     * @return bool|null
     */
    public function getFirstTimeCarrier()
    {
        return $this->FirstTimeCarrier;
    }
    /**
     * Set FirstTimeCarrier value
     * @param bool $firstTimeCarrier
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setFirstTimeCarrier($firstTimeCarrier = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstTimeCarrier) && !is_bool($firstTimeCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firstTimeCarrier, true), gettype($firstTimeCarrier)), __LINE__);
        }
        $this->FirstTimeCarrier = $firstTimeCarrier;
        return $this;
    }
    /**
     * Get LeadStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadStatus()
    {
        return isset($this->LeadStatus) ? $this->LeadStatus : null;
    }
    /**
     * Set LeadStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadStatus
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setLeadStatus($leadStatus = null)
    {
        // validation for constraint: string
        if (!is_null($leadStatus) && !is_string($leadStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadStatus, true), gettype($leadStatus)), __LINE__);
        }
        if (is_null($leadStatus) || (is_array($leadStatus) && empty($leadStatus))) {
            unset($this->LeadStatus);
        } else {
            $this->LeadStatus = $leadStatus;
        }
        return $this;
    }
    /**
     * Get LastMaintainDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastMaintainDate()
    {
        return isset($this->LastMaintainDate) ? $this->LastMaintainDate : null;
    }
    /**
     * Set LastMaintainDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastMaintainDate
     * @return \optsoapsdk\StructType\ApplicationDetail
     */
    public function setLastMaintainDate($lastMaintainDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastMaintainDate) && !is_string($lastMaintainDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastMaintainDate, true), gettype($lastMaintainDate)), __LINE__);
        }
        if (is_null($lastMaintainDate) || (is_array($lastMaintainDate) && empty($lastMaintainDate))) {
            unset($this->LastMaintainDate);
        } else {
            $this->LastMaintainDate = $lastMaintainDate;
        }
        return $this;
    }
}
