<?php

namespace optsoapsdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXLead StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DXLead
 * @subpackage Structs
 */
class DXLead extends AbstractStructBase
{
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullName;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age;
    /**
     * The NicotineUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NicotineUser;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The LeadType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadType;
    /**
     * The LeadLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadLevel;
    /**
     * The LeadStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadStatus;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $County;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The CoverageAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CoverageAmount;
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentID;
    /**
     * The SupportStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupportStatus;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The Income
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Income;
    /**
     * The UTM_Medium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UTM_Medium;
    /**
     * The ExtPartnerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtPartnerID;
    /**
     * The Mortgage_And_Consumer_Debt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mortgage_And_Consumer_Debt;
    /**
     * The StudentLoan_And_Consumer_Debt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StudentLoan_And_Consumer_Debt;
    /**
     * The Making_OverPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Making_OverPayment;
    /**
     * The Has_Descretionary_Income
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Has_Descretionary_Income;
    /**
     * The UTM_Campaign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UTM_Campaign;
    /**
     * The UTM_Source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UTM_Source;
    /**
     * The Referring_URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Referring_URL;
    /**
     * The RequirePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequirePayment;
    /**
     * The AllowResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowResale;
    /**
     * The allow_duplicate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $allow_duplicate;
    /**
     * The LeadID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadID;
    /**
     * The Lender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lender;
    /**
     * The Mortgage_Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mortgage_Date;
    /**
     * The Purchase_Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Purchase_Amount;
    /**
     * Constructor method for DXLead
     * @uses DXLead::setFullName()
     * @uses DXLead::setAge()
     * @uses DXLead::setNicotineUser()
     * @uses DXLead::setGender()
     * @uses DXLead::setLeadType()
     * @uses DXLead::setLeadLevel()
     * @uses DXLead::setLeadStatus()
     * @uses DXLead::setStreet()
     * @uses DXLead::setCity()
     * @uses DXLead::setState()
     * @uses DXLead::setCounty()
     * @uses DXLead::setZip()
     * @uses DXLead::setPhone()
     * @uses DXLead::setEmail()
     * @uses DXLead::setCoverageAmount()
     * @uses DXLead::setAgentID()
     * @uses DXLead::setSupportStatus()
     * @uses DXLead::setProductType()
     * @uses DXLead::setIncome()
     * @uses DXLead::setUTM_Medium()
     * @uses DXLead::setExtPartnerID()
     * @uses DXLead::setMortgage_And_Consumer_Debt()
     * @uses DXLead::setStudentLoan_And_Consumer_Debt()
     * @uses DXLead::setMaking_OverPayment()
     * @uses DXLead::setHas_Descretionary_Income()
     * @uses DXLead::setUTM_Campaign()
     * @uses DXLead::setUTM_Source()
     * @uses DXLead::setReferring_URL()
     * @uses DXLead::setRequirePayment()
     * @uses DXLead::setAllowResale()
     * @uses DXLead::setAllow_duplicate()
     * @uses DXLead::setLeadID()
     * @uses DXLead::setLender()
     * @uses DXLead::setMortgage_Date()
     * @uses DXLead::setPurchase_Amount()
     * @param string $fullName
     * @param int $age
     * @param string $nicotineUser
     * @param string $gender
     * @param string $leadType
     * @param string $leadLevel
     * @param string $leadStatus
     * @param string $street
     * @param string $city
     * @param string $state
     * @param string $county
     * @param string $zip
     * @param string $phone
     * @param string $email
     * @param float $coverageAmount
     * @param string $agentID
     * @param string $supportStatus
     * @param string $productType
     * @param float $income
     * @param string $uTM_Medium
     * @param string $extPartnerID
     * @param string $mortgage_And_Consumer_Debt
     * @param string $studentLoan_And_Consumer_Debt
     * @param string $making_OverPayment
     * @param string $has_Descretionary_Income
     * @param string $uTM_Campaign
     * @param string $uTM_Source
     * @param string $referring_URL
     * @param string $requirePayment
     * @param string $allowResale
     * @param string $allow_duplicate
     * @param string $leadID
     * @param string $lender
     * @param string $mortgage_Date
     * @param float $purchase_Amount
     */
    public function __construct($fullName = null, $age = null, $nicotineUser = null, $gender = null, $leadType = null, $leadLevel = null, $leadStatus = null, $street = null, $city = null, $state = null, $county = null, $zip = null, $phone = null, $email = null, $coverageAmount = null, $agentID = null, $supportStatus = null, $productType = null, $income = null, $uTM_Medium = null, $extPartnerID = null, $mortgage_And_Consumer_Debt = null, $studentLoan_And_Consumer_Debt = null, $making_OverPayment = null, $has_Descretionary_Income = null, $uTM_Campaign = null, $uTM_Source = null, $referring_URL = null, $requirePayment = null, $allowResale = null, $allow_duplicate = null, $leadID = null, $lender = null, $mortgage_Date = null, $purchase_Amount = null)
    {
        $this
            ->setFullName($fullName)
            ->setAge($age)
            ->setNicotineUser($nicotineUser)
            ->setGender($gender)
            ->setLeadType($leadType)
            ->setLeadLevel($leadLevel)
            ->setLeadStatus($leadStatus)
            ->setStreet($street)
            ->setCity($city)
            ->setState($state)
            ->setCounty($county)
            ->setZip($zip)
            ->setPhone($phone)
            ->setEmail($email)
            ->setCoverageAmount($coverageAmount)
            ->setAgentID($agentID)
            ->setSupportStatus($supportStatus)
            ->setProductType($productType)
            ->setIncome($income)
            ->setUTM_Medium($uTM_Medium)
            ->setExtPartnerID($extPartnerID)
            ->setMortgage_And_Consumer_Debt($mortgage_And_Consumer_Debt)
            ->setStudentLoan_And_Consumer_Debt($studentLoan_And_Consumer_Debt)
            ->setMaking_OverPayment($making_OverPayment)
            ->setHas_Descretionary_Income($has_Descretionary_Income)
            ->setUTM_Campaign($uTM_Campaign)
            ->setUTM_Source($uTM_Source)
            ->setReferring_URL($referring_URL)
            ->setRequirePayment($requirePayment)
            ->setAllowResale($allowResale)
            ->setAllow_duplicate($allow_duplicate)
            ->setLeadID($leadID)
            ->setLender($lender)
            ->setMortgage_Date($mortgage_Date)
            ->setPurchase_Amount($purchase_Amount);
    }
    /**
     * Get FullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullName()
    {
        return isset($this->FullName) ? $this->FullName : null;
    }
    /**
     * Set FullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullName
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        if (is_null($fullName) || (is_array($fullName) && empty($fullName))) {
            unset($this->FullName);
        } else {
            $this->FullName = $fullName;
        }
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get NicotineUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNicotineUser()
    {
        return isset($this->NicotineUser) ? $this->NicotineUser : null;
    }
    /**
     * Set NicotineUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nicotineUser
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setNicotineUser($nicotineUser = null)
    {
        // validation for constraint: string
        if (!is_null($nicotineUser) && !is_string($nicotineUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nicotineUser, true), gettype($nicotineUser)), __LINE__);
        }
        if (is_null($nicotineUser) || (is_array($nicotineUser) && empty($nicotineUser))) {
            unset($this->NicotineUser);
        } else {
            $this->NicotineUser = $nicotineUser;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gender
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get LeadType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadType()
    {
        return isset($this->LeadType) ? $this->LeadType : null;
    }
    /**
     * Set LeadType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadType
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setLeadType($leadType = null)
    {
        // validation for constraint: string
        if (!is_null($leadType) && !is_string($leadType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadType, true), gettype($leadType)), __LINE__);
        }
        if (is_null($leadType) || (is_array($leadType) && empty($leadType))) {
            unset($this->LeadType);
        } else {
            $this->LeadType = $leadType;
        }
        return $this;
    }
    /**
     * Get LeadLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadLevel()
    {
        return isset($this->LeadLevel) ? $this->LeadLevel : null;
    }
    /**
     * Set LeadLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadLevel
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setLeadLevel($leadLevel = null)
    {
        // validation for constraint: string
        if (!is_null($leadLevel) && !is_string($leadLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadLevel, true), gettype($leadLevel)), __LINE__);
        }
        if (is_null($leadLevel) || (is_array($leadLevel) && empty($leadLevel))) {
            unset($this->LeadLevel);
        } else {
            $this->LeadLevel = $leadLevel;
        }
        return $this;
    }
    /**
     * Get LeadStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadStatus()
    {
        return isset($this->LeadStatus) ? $this->LeadStatus : null;
    }
    /**
     * Set LeadStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadStatus
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setLeadStatus($leadStatus = null)
    {
        // validation for constraint: string
        if (!is_null($leadStatus) && !is_string($leadStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadStatus, true), gettype($leadStatus)), __LINE__);
        }
        if (is_null($leadStatus) || (is_array($leadStatus) && empty($leadStatus))) {
            unset($this->LeadStatus);
        } else {
            $this->LeadStatus = $leadStatus;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get County value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCounty()
    {
        return isset($this->County) ? $this->County : null;
    }
    /**
     * Set County value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $county
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        if (is_null($county) || (is_array($county) && empty($county))) {
            unset($this->County);
        } else {
            $this->County = $county;
        }
        return $this;
    }
    /**
     * Get Zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->Zip) ? $this->Zip : null;
    }
    /**
     * Set Zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->Zip);
        } else {
            $this->Zip = $zip;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get CoverageAmount value
     * @return float|null
     */
    public function getCoverageAmount()
    {
        return $this->CoverageAmount;
    }
    /**
     * Set CoverageAmount value
     * @param float $coverageAmount
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setCoverageAmount($coverageAmount = null)
    {
        // validation for constraint: float
        if (!is_null($coverageAmount) && !(is_float($coverageAmount) || is_numeric($coverageAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coverageAmount, true), gettype($coverageAmount)), __LINE__);
        }
        $this->CoverageAmount = $coverageAmount;
        return $this;
    }
    /**
     * Get AgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentID()
    {
        return isset($this->AgentID) ? $this->AgentID : null;
    }
    /**
     * Set AgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentID
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        if (is_null($agentID) || (is_array($agentID) && empty($agentID))) {
            unset($this->AgentID);
        } else {
            $this->AgentID = $agentID;
        }
        return $this;
    }
    /**
     * Get SupportStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupportStatus()
    {
        return isset($this->SupportStatus) ? $this->SupportStatus : null;
    }
    /**
     * Set SupportStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supportStatus
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setSupportStatus($supportStatus = null)
    {
        // validation for constraint: string
        if (!is_null($supportStatus) && !is_string($supportStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supportStatus, true), gettype($supportStatus)), __LINE__);
        }
        if (is_null($supportStatus) || (is_array($supportStatus) && empty($supportStatus))) {
            unset($this->SupportStatus);
        } else {
            $this->SupportStatus = $supportStatus;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productType
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get Income value
     * @return float|null
     */
    public function getIncome()
    {
        return $this->Income;
    }
    /**
     * Set Income value
     * @param float $income
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setIncome($income = null)
    {
        // validation for constraint: float
        if (!is_null($income) && !(is_float($income) || is_numeric($income))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($income, true), gettype($income)), __LINE__);
        }
        $this->Income = $income;
        return $this;
    }
    /**
     * Get UTM_Medium value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUTM_Medium()
    {
        return isset($this->UTM_Medium) ? $this->UTM_Medium : null;
    }
    /**
     * Set UTM_Medium value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uTM_Medium
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setUTM_Medium($uTM_Medium = null)
    {
        // validation for constraint: string
        if (!is_null($uTM_Medium) && !is_string($uTM_Medium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTM_Medium, true), gettype($uTM_Medium)), __LINE__);
        }
        if (is_null($uTM_Medium) || (is_array($uTM_Medium) && empty($uTM_Medium))) {
            unset($this->UTM_Medium);
        } else {
            $this->UTM_Medium = $uTM_Medium;
        }
        return $this;
    }
    /**
     * Get ExtPartnerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtPartnerID()
    {
        return isset($this->ExtPartnerID) ? $this->ExtPartnerID : null;
    }
    /**
     * Set ExtPartnerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extPartnerID
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setExtPartnerID($extPartnerID = null)
    {
        // validation for constraint: string
        if (!is_null($extPartnerID) && !is_string($extPartnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extPartnerID, true), gettype($extPartnerID)), __LINE__);
        }
        if (is_null($extPartnerID) || (is_array($extPartnerID) && empty($extPartnerID))) {
            unset($this->ExtPartnerID);
        } else {
            $this->ExtPartnerID = $extPartnerID;
        }
        return $this;
    }
    /**
     * Get Mortgage_And_Consumer_Debt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMortgage_And_Consumer_Debt()
    {
        return isset($this->Mortgage_And_Consumer_Debt) ? $this->Mortgage_And_Consumer_Debt : null;
    }
    /**
     * Set Mortgage_And_Consumer_Debt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mortgage_And_Consumer_Debt
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setMortgage_And_Consumer_Debt($mortgage_And_Consumer_Debt = null)
    {
        // validation for constraint: string
        if (!is_null($mortgage_And_Consumer_Debt) && !is_string($mortgage_And_Consumer_Debt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mortgage_And_Consumer_Debt, true), gettype($mortgage_And_Consumer_Debt)), __LINE__);
        }
        if (is_null($mortgage_And_Consumer_Debt) || (is_array($mortgage_And_Consumer_Debt) && empty($mortgage_And_Consumer_Debt))) {
            unset($this->Mortgage_And_Consumer_Debt);
        } else {
            $this->Mortgage_And_Consumer_Debt = $mortgage_And_Consumer_Debt;
        }
        return $this;
    }
    /**
     * Get StudentLoan_And_Consumer_Debt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStudentLoan_And_Consumer_Debt()
    {
        return isset($this->StudentLoan_And_Consumer_Debt) ? $this->StudentLoan_And_Consumer_Debt : null;
    }
    /**
     * Set StudentLoan_And_Consumer_Debt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $studentLoan_And_Consumer_Debt
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setStudentLoan_And_Consumer_Debt($studentLoan_And_Consumer_Debt = null)
    {
        // validation for constraint: string
        if (!is_null($studentLoan_And_Consumer_Debt) && !is_string($studentLoan_And_Consumer_Debt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($studentLoan_And_Consumer_Debt, true), gettype($studentLoan_And_Consumer_Debt)), __LINE__);
        }
        if (is_null($studentLoan_And_Consumer_Debt) || (is_array($studentLoan_And_Consumer_Debt) && empty($studentLoan_And_Consumer_Debt))) {
            unset($this->StudentLoan_And_Consumer_Debt);
        } else {
            $this->StudentLoan_And_Consumer_Debt = $studentLoan_And_Consumer_Debt;
        }
        return $this;
    }
    /**
     * Get Making_OverPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaking_OverPayment()
    {
        return isset($this->Making_OverPayment) ? $this->Making_OverPayment : null;
    }
    /**
     * Set Making_OverPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $making_OverPayment
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setMaking_OverPayment($making_OverPayment = null)
    {
        // validation for constraint: string
        if (!is_null($making_OverPayment) && !is_string($making_OverPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($making_OverPayment, true), gettype($making_OverPayment)), __LINE__);
        }
        if (is_null($making_OverPayment) || (is_array($making_OverPayment) && empty($making_OverPayment))) {
            unset($this->Making_OverPayment);
        } else {
            $this->Making_OverPayment = $making_OverPayment;
        }
        return $this;
    }
    /**
     * Get Has_Descretionary_Income value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHas_Descretionary_Income()
    {
        return isset($this->Has_Descretionary_Income) ? $this->Has_Descretionary_Income : null;
    }
    /**
     * Set Has_Descretionary_Income value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $has_Descretionary_Income
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setHas_Descretionary_Income($has_Descretionary_Income = null)
    {
        // validation for constraint: string
        if (!is_null($has_Descretionary_Income) && !is_string($has_Descretionary_Income)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($has_Descretionary_Income, true), gettype($has_Descretionary_Income)), __LINE__);
        }
        if (is_null($has_Descretionary_Income) || (is_array($has_Descretionary_Income) && empty($has_Descretionary_Income))) {
            unset($this->Has_Descretionary_Income);
        } else {
            $this->Has_Descretionary_Income = $has_Descretionary_Income;
        }
        return $this;
    }
    /**
     * Get UTM_Campaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUTM_Campaign()
    {
        return isset($this->UTM_Campaign) ? $this->UTM_Campaign : null;
    }
    /**
     * Set UTM_Campaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uTM_Campaign
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setUTM_Campaign($uTM_Campaign = null)
    {
        // validation for constraint: string
        if (!is_null($uTM_Campaign) && !is_string($uTM_Campaign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTM_Campaign, true), gettype($uTM_Campaign)), __LINE__);
        }
        if (is_null($uTM_Campaign) || (is_array($uTM_Campaign) && empty($uTM_Campaign))) {
            unset($this->UTM_Campaign);
        } else {
            $this->UTM_Campaign = $uTM_Campaign;
        }
        return $this;
    }
    /**
     * Get UTM_Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUTM_Source()
    {
        return isset($this->UTM_Source) ? $this->UTM_Source : null;
    }
    /**
     * Set UTM_Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uTM_Source
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setUTM_Source($uTM_Source = null)
    {
        // validation for constraint: string
        if (!is_null($uTM_Source) && !is_string($uTM_Source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTM_Source, true), gettype($uTM_Source)), __LINE__);
        }
        if (is_null($uTM_Source) || (is_array($uTM_Source) && empty($uTM_Source))) {
            unset($this->UTM_Source);
        } else {
            $this->UTM_Source = $uTM_Source;
        }
        return $this;
    }
    /**
     * Get Referring_URL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferring_URL()
    {
        return isset($this->Referring_URL) ? $this->Referring_URL : null;
    }
    /**
     * Set Referring_URL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referring_URL
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setReferring_URL($referring_URL = null)
    {
        // validation for constraint: string
        if (!is_null($referring_URL) && !is_string($referring_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referring_URL, true), gettype($referring_URL)), __LINE__);
        }
        if (is_null($referring_URL) || (is_array($referring_URL) && empty($referring_URL))) {
            unset($this->Referring_URL);
        } else {
            $this->Referring_URL = $referring_URL;
        }
        return $this;
    }
    /**
     * Get RequirePayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequirePayment()
    {
        return isset($this->RequirePayment) ? $this->RequirePayment : null;
    }
    /**
     * Set RequirePayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requirePayment
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setRequirePayment($requirePayment = null)
    {
        // validation for constraint: string
        if (!is_null($requirePayment) && !is_string($requirePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requirePayment, true), gettype($requirePayment)), __LINE__);
        }
        if (is_null($requirePayment) || (is_array($requirePayment) && empty($requirePayment))) {
            unset($this->RequirePayment);
        } else {
            $this->RequirePayment = $requirePayment;
        }
        return $this;
    }
    /**
     * Get AllowResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowResale()
    {
        return isset($this->AllowResale) ? $this->AllowResale : null;
    }
    /**
     * Set AllowResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowResale
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setAllowResale($allowResale = null)
    {
        // validation for constraint: string
        if (!is_null($allowResale) && !is_string($allowResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowResale, true), gettype($allowResale)), __LINE__);
        }
        if (is_null($allowResale) || (is_array($allowResale) && empty($allowResale))) {
            unset($this->AllowResale);
        } else {
            $this->AllowResale = $allowResale;
        }
        return $this;
    }
    /**
     * Get allow_duplicate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllow_duplicate()
    {
        return isset($this->allow_duplicate) ? $this->allow_duplicate : null;
    }
    /**
     * Set allow_duplicate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allow_duplicate
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setAllow_duplicate($allow_duplicate = null)
    {
        // validation for constraint: string
        if (!is_null($allow_duplicate) && !is_string($allow_duplicate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allow_duplicate, true), gettype($allow_duplicate)), __LINE__);
        }
        if (is_null($allow_duplicate) || (is_array($allow_duplicate) && empty($allow_duplicate))) {
            unset($this->allow_duplicate);
        } else {
            $this->allow_duplicate = $allow_duplicate;
        }
        return $this;
    }
    /**
     * Get LeadID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadID()
    {
        return isset($this->LeadID) ? $this->LeadID : null;
    }
    /**
     * Set LeadID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadID
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setLeadID($leadID = null)
    {
        // validation for constraint: string
        if (!is_null($leadID) && !is_string($leadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadID, true), gettype($leadID)), __LINE__);
        }
        if (is_null($leadID) || (is_array($leadID) && empty($leadID))) {
            unset($this->LeadID);
        } else {
            $this->LeadID = $leadID;
        }
        return $this;
    }
    /**
     * Get Lender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLender()
    {
        return isset($this->Lender) ? $this->Lender : null;
    }
    /**
     * Set Lender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lender
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setLender($lender = null)
    {
        // validation for constraint: string
        if (!is_null($lender) && !is_string($lender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lender, true), gettype($lender)), __LINE__);
        }
        if (is_null($lender) || (is_array($lender) && empty($lender))) {
            unset($this->Lender);
        } else {
            $this->Lender = $lender;
        }
        return $this;
    }
    /**
     * Get Mortgage_Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMortgage_Date()
    {
        return isset($this->Mortgage_Date) ? $this->Mortgage_Date : null;
    }
    /**
     * Set Mortgage_Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mortgage_Date
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setMortgage_Date($mortgage_Date = null)
    {
        // validation for constraint: string
        if (!is_null($mortgage_Date) && !is_string($mortgage_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mortgage_Date, true), gettype($mortgage_Date)), __LINE__);
        }
        if (is_null($mortgage_Date) || (is_array($mortgage_Date) && empty($mortgage_Date))) {
            unset($this->Mortgage_Date);
        } else {
            $this->Mortgage_Date = $mortgage_Date;
        }
        return $this;
    }
    /**
     * Get Purchase_Amount value
     * @return float|null
     */
    public function getPurchase_Amount()
    {
        return $this->Purchase_Amount;
    }
    /**
     * Set Purchase_Amount value
     * @param float $purchase_Amount
     * @return \optsoapsdk\StructType\DXLead
     */
    public function setPurchase_Amount($purchase_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($purchase_Amount) && !(is_float($purchase_Amount) || is_numeric($purchase_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchase_Amount, true), gettype($purchase_Amount)), __LINE__);
        }
        $this->Purchase_Amount = $purchase_Amount;
        return $this;
    }
}
