<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://dev.gittigidiyor.com:8443/listingapi/ws/IndividualUserConversationService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://dev.gittigidiyor.com:8443/listingapi/ws/IndividualUserConversationService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteConversation operation/method
 */
if ($delete->deleteConversation($apiKey, $sign, $time, new \StructType\DeleteConversationRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteConversations operation/method
 */
if ($delete->deleteConversations($apiKey, $sign, $time, new \StructType\DeleteConversationsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getConversationById operation/method
 */
if ($get->getConversationById($apiKey, $sign, $time, new \StructType\GetConversationByIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConversationSubjects operation/method
 */
if ($get->getConversationSubjects($apiKey, $sign, $time) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConversations operation/method
 */
if ($get->getConversations($apiKey, $sign, $time, new \StructType\GetConversationsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConversationsCount operation/method
 */
if ($get->getConversationsCount($apiKey, $sign, $time, new \StructType\GetConversationsCountRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMessages operation/method
 */
if ($get->getMessages($apiKey, $sign, $time, new \StructType\GetMessagesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServiceName operation/method
 */
if ($get->getServiceName() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for markAsRead operation/method
 */
if ($mark->markAsRead($apiKey, $sign, $time, new \StructType\MarkAsReadRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markAsUnread operation/method
 */
if ($mark->markAsUnread($apiKey, $sign, $time, new \StructType\MarkAsUnreadRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Post ServiceType
 */
$post = new \ServiceType\Post($options);
/**
 * Sample call for postConversation operation/method
 */
if ($post->postConversation($apiKey, $sign, $time, new \StructType\PostConversationRequest()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Samples for Put ServiceType
 */
$put = new \ServiceType\Put($options);
/**
 * Sample call for putMessage operation/method
 */
if ($put->putMessage($apiKey, $sign, $time, new \StructType\PutMessageRequest()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
