<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getConversationsRequest StructType
 * @subpackage Structs
 */
class GetConversationsRequest extends AbstractStructBase
{
    /**
     * The startOffSet
     * @var int
     */
    public $startOffSet;
    /**
     * The rowCount
     * @var int
     */
    public $rowCount;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The messageType
     * @var string
     */
    public $messageType;
    /**
     * The filteredUserNick
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filteredUserNick;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * Constructor method for getConversationsRequest
     * @uses GetConversationsRequest::setStartOffSet()
     * @uses GetConversationsRequest::setRowCount()
     * @uses GetConversationsRequest::setTitle()
     * @uses GetConversationsRequest::setMessageType()
     * @uses GetConversationsRequest::setFilteredUserNick()
     * @uses GetConversationsRequest::setLang()
     * @param int $startOffSet
     * @param int $rowCount
     * @param string $title
     * @param string $messageType
     * @param string $filteredUserNick
     * @param string $lang
     */
    public function __construct($startOffSet = null, $rowCount = null, $title = null, $messageType = null, $filteredUserNick = null, $lang = null)
    {
        $this
            ->setStartOffSet($startOffSet)
            ->setRowCount($rowCount)
            ->setTitle($title)
            ->setMessageType($messageType)
            ->setFilteredUserNick($filteredUserNick)
            ->setLang($lang);
    }
    /**
     * Get startOffSet value
     * @return int|null
     */
    public function getStartOffSet()
    {
        return $this->startOffSet;
    }
    /**
     * Set startOffSet value
     * @param int $startOffSet
     * @return \StructType\GetConversationsRequest
     */
    public function setStartOffSet($startOffSet = null)
    {
        // validation for constraint: int
        if (!is_null($startOffSet) && !(is_int($startOffSet) || ctype_digit($startOffSet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startOffSet, true), gettype($startOffSet)), __LINE__);
        }
        $this->startOffSet = $startOffSet;
        return $this;
    }
    /**
     * Get rowCount value
     * @return int|null
     */
    public function getRowCount()
    {
        return $this->rowCount;
    }
    /**
     * Set rowCount value
     * @param int $rowCount
     * @return \StructType\GetConversationsRequest
     */
    public function setRowCount($rowCount = null)
    {
        // validation for constraint: int
        if (!is_null($rowCount) && !(is_int($rowCount) || ctype_digit($rowCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowCount, true), gettype($rowCount)), __LINE__);
        }
        $this->rowCount = $rowCount;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\GetConversationsRequest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\GetConversationsRequest
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get filteredUserNick value
     * @return string|null
     */
    public function getFilteredUserNick()
    {
        return $this->filteredUserNick;
    }
    /**
     * Set filteredUserNick value
     * @param string $filteredUserNick
     * @return \StructType\GetConversationsRequest
     */
    public function setFilteredUserNick($filteredUserNick = null)
    {
        // validation for constraint: string
        if (!is_null($filteredUserNick) && !is_string($filteredUserNick)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filteredUserNick, true), gettype($filteredUserNick)), __LINE__);
        }
        $this->filteredUserNick = $filteredUserNick;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\GetConversationsRequest
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
}
