<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Post ServiceType
 * @subpackage Services
 */
class Post extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named postConversation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\PostConversationRequest $postConversationRequest
     * @return \StructType\UserConversationPostingResponse|bool
     */
    public function postConversation($apiKey, $sign, $time, \StructType\PostConversationRequest $postConversationRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->postConversation($apiKey, $sign, $time, $postConversationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserConversationPostingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
