<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleDto StructType
 * @subpackage Structs
 */
class SaleDto extends AbstractStructBase
{
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleCode;
    /**
     * The saleTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleTitle;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * Constructor method for saleDto
     * @uses SaleDto::setSaleCode()
     * @uses SaleDto::setSaleTitle()
     * @uses SaleDto::setProductId()
     * @param string $saleCode
     * @param string $saleTitle
     * @param int $productId
     */
    public function __construct($saleCode = null, $saleTitle = null, $productId = null)
    {
        $this
            ->setSaleCode($saleCode)
            ->setSaleTitle($saleTitle)
            ->setProductId($productId);
    }
    /**
     * Get saleCode value
     * @return string|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * Set saleCode value
     * @param string $saleCode
     * @return \StructType\SaleDto
     */
    public function setSaleCode($saleCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCode) && !is_string($saleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCode, true), gettype($saleCode)), __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Get saleTitle value
     * @return string|null
     */
    public function getSaleTitle()
    {
        return $this->saleTitle;
    }
    /**
     * Set saleTitle value
     * @param string $saleTitle
     * @return \StructType\SaleDto
     */
    public function setSaleTitle($saleTitle = null)
    {
        // validation for constraint: string
        if (!is_null($saleTitle) && !is_string($saleTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleTitle, true), gettype($saleTitle)), __LINE__);
        }
        $this->saleTitle = $saleTitle;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\SaleDto
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
}
