<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messages StructType
 * @subpackage Structs
 */
class Messages extends AbstractStructBase
{
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MessageDto[]
     */
    public $message;
    /**
     * Constructor method for messages
     * @uses Messages::setMessage()
     * @param \StructType\MessageDto[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get message value
     * @return \StructType\MessageDto[]|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * This method is responsible for validating the values passed to the setMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageForArrayConstraintsFromSetMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messagesMessageItem) {
            // validation for constraint: itemType
            if (!$messagesMessageItem instanceof \StructType\MessageDto) {
                $invalidValues[] = is_object($messagesMessageItem) ? get_class($messagesMessageItem) : sprintf('%s(%s)', gettype($messagesMessageItem), var_export($messagesMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The message property can only contain items of type \StructType\MessageDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set message value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageDto[] $message
     * @return \StructType\Messages
     */
    public function setMessage(array $message = array())
    {
        // validation for constraint: array
        if ('' !== ($messageArrayErrorMessage = self::validateMessageForArrayConstraintsFromSetMessage($message))) {
            throw new \InvalidArgumentException($messageArrayErrorMessage, __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Add item to message value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageDto $item
     * @return \StructType\Messages
     */
    public function addToMessage(\StructType\MessageDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessageDto) {
            throw new \InvalidArgumentException(sprintf('The message property can only contain items of type \StructType\MessageDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->message[] = $item;
        return $this;
    }
}
