<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMessagesRequest StructType
 * @subpackage Structs
 */
class GetMessagesRequest extends AbstractStructBase
{
    /**
     * The conversationId
     * @var string
     */
    public $conversationId;
    /**
     * The rowCount
     * @var int
     */
    public $rowCount;
    /**
     * The startOffset
     * @var int
     */
    public $startOffset;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * Constructor method for getMessagesRequest
     * @uses GetMessagesRequest::setConversationId()
     * @uses GetMessagesRequest::setRowCount()
     * @uses GetMessagesRequest::setStartOffset()
     * @uses GetMessagesRequest::setLang()
     * @param string $conversationId
     * @param int $rowCount
     * @param int $startOffset
     * @param string $lang
     */
    public function __construct($conversationId = null, $rowCount = null, $startOffset = null, $lang = null)
    {
        $this
            ->setConversationId($conversationId)
            ->setRowCount($rowCount)
            ->setStartOffset($startOffset)
            ->setLang($lang);
    }
    /**
     * Get conversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }
    /**
     * Set conversationId value
     * @param string $conversationId
     * @return \StructType\GetMessagesRequest
     */
    public function setConversationId($conversationId = null)
    {
        // validation for constraint: string
        if (!is_null($conversationId) && !is_string($conversationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversationId, true), gettype($conversationId)), __LINE__);
        }
        $this->conversationId = $conversationId;
        return $this;
    }
    /**
     * Get rowCount value
     * @return int|null
     */
    public function getRowCount()
    {
        return $this->rowCount;
    }
    /**
     * Set rowCount value
     * @param int $rowCount
     * @return \StructType\GetMessagesRequest
     */
    public function setRowCount($rowCount = null)
    {
        // validation for constraint: int
        if (!is_null($rowCount) && !(is_int($rowCount) || ctype_digit($rowCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowCount, true), gettype($rowCount)), __LINE__);
        }
        $this->rowCount = $rowCount;
        return $this;
    }
    /**
     * Get startOffset value
     * @return int|null
     */
    public function getStartOffset()
    {
        return $this->startOffset;
    }
    /**
     * Set startOffset value
     * @param int $startOffset
     * @return \StructType\GetMessagesRequest
     */
    public function setStartOffset($startOffset = null)
    {
        // validation for constraint: int
        if (!is_null($startOffset) && !(is_int($startOffset) || ctype_digit($startOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startOffset, true), gettype($startOffset)), __LINE__);
        }
        $this->startOffset = $startOffset;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\GetMessagesRequest
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
}
