<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messageDto StructType
 * @subpackage Structs
 */
class MessageDto extends AbstractStructBase
{
    /**
     * The messageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $messageId;
    /**
     * The messageText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageText;
    /**
     * The messageDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageDate;
    /**
     * The senderNickName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senderNickName;
    /**
     * Constructor method for messageDto
     * @uses MessageDto::setMessageId()
     * @uses MessageDto::setMessageText()
     * @uses MessageDto::setMessageDate()
     * @uses MessageDto::setSenderNickName()
     * @param int $messageId
     * @param string $messageText
     * @param string $messageDate
     * @param string $senderNickName
     */
    public function __construct($messageId = null, $messageText = null, $messageDate = null, $senderNickName = null)
    {
        $this
            ->setMessageId($messageId)
            ->setMessageText($messageText)
            ->setMessageDate($messageDate)
            ->setSenderNickName($senderNickName);
    }
    /**
     * Get messageId value
     * @return int|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param int $messageId
     * @return \StructType\MessageDto
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: int
        if (!is_null($messageId) && !(is_int($messageId) || ctype_digit($messageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get messageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->messageText;
    }
    /**
     * Set messageText value
     * @param string $messageText
     * @return \StructType\MessageDto
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageText, true), gettype($messageText)), __LINE__);
        }
        $this->messageText = $messageText;
        return $this;
    }
    /**
     * Get messageDate value
     * @return string|null
     */
    public function getMessageDate()
    {
        return $this->messageDate;
    }
    /**
     * Set messageDate value
     * @param string $messageDate
     * @return \StructType\MessageDto
     */
    public function setMessageDate($messageDate = null)
    {
        // validation for constraint: string
        if (!is_null($messageDate) && !is_string($messageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDate, true), gettype($messageDate)), __LINE__);
        }
        $this->messageDate = $messageDate;
        return $this;
    }
    /**
     * Get senderNickName value
     * @return string|null
     */
    public function getSenderNickName()
    {
        return $this->senderNickName;
    }
    /**
     * Set senderNickName value
     * @param string $senderNickName
     * @return \StructType\MessageDto
     */
    public function setSenderNickName($senderNickName = null)
    {
        // validation for constraint: string
        if (!is_null($senderNickName) && !is_string($senderNickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderNickName, true), gettype($senderNickName)), __LINE__);
        }
        $this->senderNickName = $senderNickName;
        return $this;
    }
}
