<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named markAsRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\MarkAsReadRequest $markAsReadRequest
     * @return \StructType\UserConversationMarkingReadResponse|bool
     */
    public function markAsRead($apiKey, $sign, $time, \StructType\MarkAsReadRequest $markAsReadRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->markAsRead($apiKey, $sign, $time, $markAsReadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named markAsUnread
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\MarkAsUnreadRequest $markAsUnreadRequest
     * @return \StructType\UserConversationMarkingReadResponse|bool
     */
    public function markAsUnread($apiKey, $sign, $time, \StructType\MarkAsUnreadRequest $markAsUnreadRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->markAsUnread($apiKey, $sign, $time, $markAsUnreadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserConversationMarkingReadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
