<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userConversationLoadingType StructType
 * @subpackage Structs
 */
class UserConversationLoadingType extends AbstractStructBase
{
    /**
     * The conversationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $conversationId;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createDate;
    /**
     * The context
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContextDto
     */
    public $context;
    /**
     * The requestingParticipant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParticipantDto
     */
    public $requestingParticipant;
    /**
     * The participants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Participants
     */
    public $participants;
    /**
     * The lastMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageDto
     */
    public $lastMessage;
    /**
     * The messageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageType;
    /**
     * Constructor method for userConversationLoadingType
     * @uses UserConversationLoadingType::setConversationId()
     * @uses UserConversationLoadingType::setTitle()
     * @uses UserConversationLoadingType::setCreateDate()
     * @uses UserConversationLoadingType::setContext()
     * @uses UserConversationLoadingType::setRequestingParticipant()
     * @uses UserConversationLoadingType::setParticipants()
     * @uses UserConversationLoadingType::setLastMessage()
     * @uses UserConversationLoadingType::setMessageType()
     * @param string $conversationId
     * @param string $title
     * @param string $createDate
     * @param \StructType\ContextDto $context
     * @param \StructType\ParticipantDto $requestingParticipant
     * @param \StructType\Participants $participants
     * @param \StructType\MessageDto $lastMessage
     * @param string $messageType
     */
    public function __construct($conversationId = null, $title = null, $createDate = null, \StructType\ContextDto $context = null, \StructType\ParticipantDto $requestingParticipant = null, \StructType\Participants $participants = null, \StructType\MessageDto $lastMessage = null, $messageType = null)
    {
        $this
            ->setConversationId($conversationId)
            ->setTitle($title)
            ->setCreateDate($createDate)
            ->setContext($context)
            ->setRequestingParticipant($requestingParticipant)
            ->setParticipants($participants)
            ->setLastMessage($lastMessage)
            ->setMessageType($messageType);
    }
    /**
     * Get conversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }
    /**
     * Set conversationId value
     * @param string $conversationId
     * @return \StructType\UserConversationLoadingType
     */
    public function setConversationId($conversationId = null)
    {
        // validation for constraint: string
        if (!is_null($conversationId) && !is_string($conversationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversationId, true), gettype($conversationId)), __LINE__);
        }
        $this->conversationId = $conversationId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\UserConversationLoadingType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\UserConversationLoadingType
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get context value
     * @return \StructType\ContextDto|null
     */
    public function getContext()
    {
        return $this->context;
    }
    /**
     * Set context value
     * @param \StructType\ContextDto $context
     * @return \StructType\UserConversationLoadingType
     */
    public function setContext(\StructType\ContextDto $context = null)
    {
        $this->context = $context;
        return $this;
    }
    /**
     * Get requestingParticipant value
     * @return \StructType\ParticipantDto|null
     */
    public function getRequestingParticipant()
    {
        return $this->requestingParticipant;
    }
    /**
     * Set requestingParticipant value
     * @param \StructType\ParticipantDto $requestingParticipant
     * @return \StructType\UserConversationLoadingType
     */
    public function setRequestingParticipant(\StructType\ParticipantDto $requestingParticipant = null)
    {
        $this->requestingParticipant = $requestingParticipant;
        return $this;
    }
    /**
     * Get participants value
     * @return \StructType\Participants|null
     */
    public function getParticipants()
    {
        return $this->participants;
    }
    /**
     * Set participants value
     * @param \StructType\Participants $participants
     * @return \StructType\UserConversationLoadingType
     */
    public function setParticipants(\StructType\Participants $participants = null)
    {
        $this->participants = $participants;
        return $this;
    }
    /**
     * Get lastMessage value
     * @return \StructType\MessageDto|null
     */
    public function getLastMessage()
    {
        return $this->lastMessage;
    }
    /**
     * Set lastMessage value
     * @param \StructType\MessageDto $lastMessage
     * @return \StructType\UserConversationLoadingType
     */
    public function setLastMessage(\StructType\MessageDto $lastMessage = null)
    {
        $this->lastMessage = $lastMessage;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @uses \EnumType\MessageType::valueIsValid()
     * @uses \EnumType\MessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \StructType\UserConversationLoadingType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageType', is_array($messageType) ? implode(', ', $messageType) : var_export($messageType, true), implode(', ', \EnumType\MessageType::getValidValues())), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
}
