<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getConversationByIdRequest StructType
 * @subpackage Structs
 */
class GetConversationByIdRequest extends AbstractStructBase
{
    /**
     * The conversationId
     * @var string
     */
    public $conversationId;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * Constructor method for getConversationByIdRequest
     * @uses GetConversationByIdRequest::setConversationId()
     * @uses GetConversationByIdRequest::setLang()
     * @param string $conversationId
     * @param string $lang
     */
    public function __construct($conversationId = null, $lang = null)
    {
        $this
            ->setConversationId($conversationId)
            ->setLang($lang);
    }
    /**
     * Get conversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }
    /**
     * Set conversationId value
     * @param string $conversationId
     * @return \StructType\GetConversationByIdRequest
     */
    public function setConversationId($conversationId = null)
    {
        // validation for constraint: string
        if (!is_null($conversationId) && !is_string($conversationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversationId, true), gettype($conversationId)), __LINE__);
        }
        $this->conversationId = $conversationId;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\GetConversationByIdRequest
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
}
