<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subject StructType
 * @subpackage Structs
 */
class Subject extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The displayText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayText;
    /**
     * Constructor method for subject
     * @uses Subject::setType()
     * @uses Subject::setDisplayText()
     * @param string $type
     * @param string $displayText
     */
    public function __construct($type = null, $displayText = null)
    {
        $this
            ->setType($type)
            ->setDisplayText($displayText);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Subject
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get displayText value
     * @return string|null
     */
    public function getDisplayText()
    {
        return $this->displayText;
    }
    /**
     * Set displayText value
     * @param string $displayText
     * @return \StructType\Subject
     */
    public function setDisplayText($displayText = null)
    {
        // validation for constraint: string
        if (!is_null($displayText) && !is_string($displayText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayText, true), gettype($displayText)), __LINE__);
        }
        $this->displayText = $displayText;
        return $this;
    }
}
