<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteConversation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\DeleteConversationRequest $deleteConversationRequest
     * @return \StructType\UserConversationDeletingResponse|bool
     */
    public function deleteConversation($apiKey, $sign, $time, \StructType\DeleteConversationRequest $deleteConversationRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteConversation($apiKey, $sign, $time, $deleteConversationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteConversations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\DeleteConversationsRequest $deleteConversationsRequest
     * @return \StructType\UserConversationDeletingResponse|bool
     */
    public function deleteConversations($apiKey, $sign, $time, \StructType\DeleteConversationsRequest $deleteConversationsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteConversations($apiKey, $sign, $time, $deleteConversationsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserConversationDeletingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
