<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getConversationById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\GetConversationByIdRequest $getConversationByIdRequest
     * @return \StructType\UserConversationLoadingResponse|bool
     */
    public function getConversationById($apiKey, $sign, $time, \StructType\GetConversationByIdRequest $getConversationByIdRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getConversationById($apiKey, $sign, $time, $getConversationByIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConversationSubjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @return \StructType\UserSubjectLoadingResponse|bool
     */
    public function getConversationSubjects($apiKey, $sign, $time)
    {
        try {
            $this->setResult($this->getSoapClient()->getConversationSubjects($apiKey, $sign, $time));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConversations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\GetConversationsRequest $getConversationsRequest
     * @return \StructType\UserConversationsLoadingResponse|bool
     */
    public function getConversations($apiKey, $sign, $time, \StructType\GetConversationsRequest $getConversationsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getConversations($apiKey, $sign, $time, $getConversationsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConversationsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\GetConversationsCountRequest $getConversationsCountRequest
     * @return \StructType\UserConversationCountResponse|bool
     */
    public function getConversationsCount($apiKey, $sign, $time, \StructType\GetConversationsCountRequest $getConversationsCountRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getConversationsCount($apiKey, $sign, $time, $getConversationsCountRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \StructType\GetMessagesRequest $getMessagesRequest
     * @return \StructType\UserMessageLoadingResponse|bool
     */
    public function getMessages($apiKey, $sign, $time, \StructType\GetMessagesRequest $getMessagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getMessages($apiKey, $sign, $time, $getMessagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getServiceName()
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceName());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\UserConversationCountResponse|\StructType\UserConversationLoadingResponse|\StructType\UserConversationsLoadingResponse|\StructType\UserMessageLoadingResponse|\StructType\UserSubjectLoadingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
