<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contextDto StructType
 * @subpackage Structs
 */
class ContextDto extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductDto
     */
    public $product;
    /**
     * The sale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleDto
     */
    public $sale;
    /**
     * Constructor method for contextDto
     * @uses ContextDto::setProduct()
     * @uses ContextDto::setSale()
     * @param \StructType\ProductDto $product
     * @param \StructType\SaleDto $sale
     */
    public function __construct(\StructType\ProductDto $product = null, \StructType\SaleDto $sale = null)
    {
        $this
            ->setProduct($product)
            ->setSale($sale);
    }
    /**
     * Get product value
     * @return \StructType\ProductDto|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ProductDto $product
     * @return \StructType\ContextDto
     */
    public function setProduct(\StructType\ProductDto $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get sale value
     * @return \StructType\SaleDto|null
     */
    public function getSale()
    {
        return $this->sale;
    }
    /**
     * Set sale value
     * @param \StructType\SaleDto $sale
     * @return \StructType\ContextDto
     */
    public function setSale(\StructType\SaleDto $sale = null)
    {
        $this->sale = $sale;
        return $this;
    }
}
