<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userSubjectLoadingResponse StructType
 * @subpackage Structs
 */
class UserSubjectLoadingResponse extends BaseResponse
{
    /**
     * The subjects
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Subjects
     */
    public $subjects;
    /**
     * The totalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalCount;
    /**
     * Constructor method for userSubjectLoadingResponse
     * @uses UserSubjectLoadingResponse::setSubjects()
     * @uses UserSubjectLoadingResponse::setTotalCount()
     * @param \StructType\Subjects $subjects
     * @param int $totalCount
     */
    public function __construct(\StructType\Subjects $subjects = null, $totalCount = null)
    {
        $this
            ->setSubjects($subjects)
            ->setTotalCount($totalCount);
    }
    /**
     * Get subjects value
     * @return \StructType\Subjects|null
     */
    public function getSubjects()
    {
        return $this->subjects;
    }
    /**
     * Set subjects value
     * @param \StructType\Subjects $subjects
     * @return \StructType\UserSubjectLoadingResponse
     */
    public function setSubjects(\StructType\Subjects $subjects = null)
    {
        $this->subjects = $subjects;
        return $this;
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\UserSubjectLoadingResponse
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
}
