<?php

namespace optsoapsdk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateAgent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\UpdateAgent $parameters
     * @return \optsoapsdk\StructType\UpdateAgentResponse|bool
     */
    public function UpdateAgent(\optsoapsdk\StructType\UpdateAgent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAgent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAgentLevelUpline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\UpdateAgentLevelUpline $parameters
     * @return \optsoapsdk\StructType\UpdateAgentLevelUplineResponse|bool
     */
    public function UpdateAgentLevelUpline(\optsoapsdk\StructType\UpdateAgentLevelUpline $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAgentLevelUpline($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \optsoapsdk\StructType\UpdateAgentLevelUplineResponse|\optsoapsdk\StructType\UpdateAgentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
