<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleProcessTypeV2 StructType
 * @subpackage Structs
 */
class SaleProcessTypeV2 extends AbstractStructBase
{
    /**
     * The commissions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SrsProcessFvfCommissionType[]
     */
    public $commissions;
    /**
     * The ggRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ggRevenue;
    /**
     * The installmentRevenueVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $installmentRevenueVatAmount;
    /**
     * The installmentRevenueVatBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $installmentRevenueVatBasis;
    /**
     * The paidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $paidAmount;
    /**
     * The paymentChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentChannel;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleCode;
    /**
     * The saleDiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $saleDiscountAmount;
    /**
     * The sellerAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sellerAmount;
    /**
     * The sellerBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sellerBalance;
    /**
     * The srsCompleteTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $srsCompleteTime;
    /**
     * The totalMerchantCommissionCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalMerchantCommissionCost;
    /**
     * The transferStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transferStatus;
    /**
     * Constructor method for saleProcessTypeV2
     * @uses SaleProcessTypeV2::setCommissions()
     * @uses SaleProcessTypeV2::setGgRevenue()
     * @uses SaleProcessTypeV2::setInstallmentRevenueVatAmount()
     * @uses SaleProcessTypeV2::setInstallmentRevenueVatBasis()
     * @uses SaleProcessTypeV2::setPaidAmount()
     * @uses SaleProcessTypeV2::setPaymentChannel()
     * @uses SaleProcessTypeV2::setPrice()
     * @uses SaleProcessTypeV2::setSaleCode()
     * @uses SaleProcessTypeV2::setSaleDiscountAmount()
     * @uses SaleProcessTypeV2::setSellerAmount()
     * @uses SaleProcessTypeV2::setSellerBalance()
     * @uses SaleProcessTypeV2::setSrsCompleteTime()
     * @uses SaleProcessTypeV2::setTotalMerchantCommissionCost()
     * @uses SaleProcessTypeV2::setTransferStatus()
     * @param \StructType\SrsProcessFvfCommissionType[] $commissions
     * @param float $ggRevenue
     * @param float $installmentRevenueVatAmount
     * @param float $installmentRevenueVatBasis
     * @param float $paidAmount
     * @param string $paymentChannel
     * @param float $price
     * @param string $saleCode
     * @param float $saleDiscountAmount
     * @param float $sellerAmount
     * @param float $sellerBalance
     * @param string $srsCompleteTime
     * @param float $totalMerchantCommissionCost
     * @param string $transferStatus
     */
    public function __construct(array $commissions = array(), $ggRevenue = null, $installmentRevenueVatAmount = null, $installmentRevenueVatBasis = null, $paidAmount = null, $paymentChannel = null, $price = null, $saleCode = null, $saleDiscountAmount = null, $sellerAmount = null, $sellerBalance = null, $srsCompleteTime = null, $totalMerchantCommissionCost = null, $transferStatus = null)
    {
        $this
            ->setCommissions($commissions)
            ->setGgRevenue($ggRevenue)
            ->setInstallmentRevenueVatAmount($installmentRevenueVatAmount)
            ->setInstallmentRevenueVatBasis($installmentRevenueVatBasis)
            ->setPaidAmount($paidAmount)
            ->setPaymentChannel($paymentChannel)
            ->setPrice($price)
            ->setSaleCode($saleCode)
            ->setSaleDiscountAmount($saleDiscountAmount)
            ->setSellerAmount($sellerAmount)
            ->setSellerBalance($sellerBalance)
            ->setSrsCompleteTime($srsCompleteTime)
            ->setTotalMerchantCommissionCost($totalMerchantCommissionCost)
            ->setTransferStatus($transferStatus);
    }
    /**
     * Get commissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SrsProcessFvfCommissionType[]|null
     */
    public function getCommissions()
    {
        return isset($this->commissions) ? $this->commissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCommissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionsForArrayConstraintsFromSetCommissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $saleProcessTypeV2CommissionsItem) {
            // validation for constraint: itemType
            if (!$saleProcessTypeV2CommissionsItem instanceof \StructType\SrsProcessFvfCommissionType) {
                $invalidValues[] = is_object($saleProcessTypeV2CommissionsItem) ? get_class($saleProcessTypeV2CommissionsItem) : sprintf('%s(%s)', gettype($saleProcessTypeV2CommissionsItem), var_export($saleProcessTypeV2CommissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The commissions property can only contain items of type \StructType\SrsProcessFvfCommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set commissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SrsProcessFvfCommissionType[] $commissions
     * @return \StructType\SaleProcessTypeV2
     */
    public function setCommissions(array $commissions = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionsArrayErrorMessage = self::validateCommissionsForArrayConstraintsFromSetCommissions($commissions))) {
            throw new \InvalidArgumentException($commissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($commissions) || (is_array($commissions) && empty($commissions))) {
            unset($this->commissions);
        } else {
            $this->commissions = $commissions;
        }
        return $this;
    }
    /**
     * Add item to commissions value
     * @throws \InvalidArgumentException
     * @param \StructType\SrsProcessFvfCommissionType $item
     * @return \StructType\SaleProcessTypeV2
     */
    public function addToCommissions(\StructType\SrsProcessFvfCommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SrsProcessFvfCommissionType) {
            throw new \InvalidArgumentException(sprintf('The commissions property can only contain items of type \StructType\SrsProcessFvfCommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->commissions[] = $item;
        return $this;
    }
    /**
     * Get ggRevenue value
     * @return float|null
     */
    public function getGgRevenue()
    {
        return $this->ggRevenue;
    }
    /**
     * Set ggRevenue value
     * @param float $ggRevenue
     * @return \StructType\SaleProcessTypeV2
     */
    public function setGgRevenue($ggRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($ggRevenue) && !(is_float($ggRevenue) || is_numeric($ggRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ggRevenue, true), gettype($ggRevenue)), __LINE__);
        }
        $this->ggRevenue = $ggRevenue;
        return $this;
    }
    /**
     * Get installmentRevenueVatAmount value
     * @return float|null
     */
    public function getInstallmentRevenueVatAmount()
    {
        return $this->installmentRevenueVatAmount;
    }
    /**
     * Set installmentRevenueVatAmount value
     * @param float $installmentRevenueVatAmount
     * @return \StructType\SaleProcessTypeV2
     */
    public function setInstallmentRevenueVatAmount($installmentRevenueVatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($installmentRevenueVatAmount) && !(is_float($installmentRevenueVatAmount) || is_numeric($installmentRevenueVatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentRevenueVatAmount, true), gettype($installmentRevenueVatAmount)), __LINE__);
        }
        $this->installmentRevenueVatAmount = $installmentRevenueVatAmount;
        return $this;
    }
    /**
     * Get installmentRevenueVatBasis value
     * @return float|null
     */
    public function getInstallmentRevenueVatBasis()
    {
        return $this->installmentRevenueVatBasis;
    }
    /**
     * Set installmentRevenueVatBasis value
     * @param float $installmentRevenueVatBasis
     * @return \StructType\SaleProcessTypeV2
     */
    public function setInstallmentRevenueVatBasis($installmentRevenueVatBasis = null)
    {
        // validation for constraint: float
        if (!is_null($installmentRevenueVatBasis) && !(is_float($installmentRevenueVatBasis) || is_numeric($installmentRevenueVatBasis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentRevenueVatBasis, true), gettype($installmentRevenueVatBasis)), __LINE__);
        }
        $this->installmentRevenueVatBasis = $installmentRevenueVatBasis;
        return $this;
    }
    /**
     * Get paidAmount value
     * @return float|null
     */
    public function getPaidAmount()
    {
        return $this->paidAmount;
    }
    /**
     * Set paidAmount value
     * @param float $paidAmount
     * @return \StructType\SaleProcessTypeV2
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paidAmount) && !(is_float($paidAmount) || is_numeric($paidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->paidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get paymentChannel value
     * @return string|null
     */
    public function getPaymentChannel()
    {
        return $this->paymentChannel;
    }
    /**
     * Set paymentChannel value
     * @uses \EnumType\OrderTransactionChannelType::valueIsValid()
     * @uses \EnumType\OrderTransactionChannelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentChannel
     * @return \StructType\SaleProcessTypeV2
     */
    public function setPaymentChannel($paymentChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderTransactionChannelType::valueIsValid($paymentChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderTransactionChannelType', is_array($paymentChannel) ? implode(', ', $paymentChannel) : var_export($paymentChannel, true), implode(', ', \EnumType\OrderTransactionChannelType::getValidValues())), __LINE__);
        }
        $this->paymentChannel = $paymentChannel;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\SaleProcessTypeV2
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get saleCode value
     * @return string|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * Set saleCode value
     * @param string $saleCode
     * @return \StructType\SaleProcessTypeV2
     */
    public function setSaleCode($saleCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCode) && !is_string($saleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCode, true), gettype($saleCode)), __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Get saleDiscountAmount value
     * @return float|null
     */
    public function getSaleDiscountAmount()
    {
        return $this->saleDiscountAmount;
    }
    /**
     * Set saleDiscountAmount value
     * @param float $saleDiscountAmount
     * @return \StructType\SaleProcessTypeV2
     */
    public function setSaleDiscountAmount($saleDiscountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($saleDiscountAmount) && !(is_float($saleDiscountAmount) || is_numeric($saleDiscountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleDiscountAmount, true), gettype($saleDiscountAmount)), __LINE__);
        }
        $this->saleDiscountAmount = $saleDiscountAmount;
        return $this;
    }
    /**
     * Get sellerAmount value
     * @return float|null
     */
    public function getSellerAmount()
    {
        return $this->sellerAmount;
    }
    /**
     * Set sellerAmount value
     * @param float $sellerAmount
     * @return \StructType\SaleProcessTypeV2
     */
    public function setSellerAmount($sellerAmount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerAmount) && !(is_float($sellerAmount) || is_numeric($sellerAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerAmount, true), gettype($sellerAmount)), __LINE__);
        }
        $this->sellerAmount = $sellerAmount;
        return $this;
    }
    /**
     * Get sellerBalance value
     * @return float|null
     */
    public function getSellerBalance()
    {
        return $this->sellerBalance;
    }
    /**
     * Set sellerBalance value
     * @param float $sellerBalance
     * @return \StructType\SaleProcessTypeV2
     */
    public function setSellerBalance($sellerBalance = null)
    {
        // validation for constraint: float
        if (!is_null($sellerBalance) && !(is_float($sellerBalance) || is_numeric($sellerBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerBalance, true), gettype($sellerBalance)), __LINE__);
        }
        $this->sellerBalance = $sellerBalance;
        return $this;
    }
    /**
     * Get srsCompleteTime value
     * @return string|null
     */
    public function getSrsCompleteTime()
    {
        return $this->srsCompleteTime;
    }
    /**
     * Set srsCompleteTime value
     * @param string $srsCompleteTime
     * @return \StructType\SaleProcessTypeV2
     */
    public function setSrsCompleteTime($srsCompleteTime = null)
    {
        // validation for constraint: string
        if (!is_null($srsCompleteTime) && !is_string($srsCompleteTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srsCompleteTime, true), gettype($srsCompleteTime)), __LINE__);
        }
        $this->srsCompleteTime = $srsCompleteTime;
        return $this;
    }
    /**
     * Get totalMerchantCommissionCost value
     * @return float|null
     */
    public function getTotalMerchantCommissionCost()
    {
        return $this->totalMerchantCommissionCost;
    }
    /**
     * Set totalMerchantCommissionCost value
     * @param float $totalMerchantCommissionCost
     * @return \StructType\SaleProcessTypeV2
     */
    public function setTotalMerchantCommissionCost($totalMerchantCommissionCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalMerchantCommissionCost) && !(is_float($totalMerchantCommissionCost) || is_numeric($totalMerchantCommissionCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalMerchantCommissionCost, true), gettype($totalMerchantCommissionCost)), __LINE__);
        }
        $this->totalMerchantCommissionCost = $totalMerchantCommissionCost;
        return $this;
    }
    /**
     * Get transferStatus value
     * @return string|null
     */
    public function getTransferStatus()
    {
        return $this->transferStatus;
    }
    /**
     * Set transferStatus value
     * @uses \EnumType\SrsProcessTransferStatusType::valueIsValid()
     * @uses \EnumType\SrsProcessTransferStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\SaleProcessTypeV2
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SrsProcessTransferStatusType::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SrsProcessTransferStatusType', is_array($transferStatus) ? implode(', ', $transferStatus) : var_export($transferStatus, true), implode(', ', \EnumType\SrsProcessTransferStatusType::getValidValues())), __LINE__);
        }
        $this->transferStatus = $transferStatus;
        return $this;
    }
}
