<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sales StructType
 * @subpackage Structs
 */
class Sales extends AbstractStructBase
{
    /**
     * The sale
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaleType[]
     */
    public $sale;
    /**
     * Constructor method for sales
     * @uses Sales::setSale()
     * @param \StructType\SaleType[] $sale
     */
    public function __construct(array $sale = array())
    {
        $this
            ->setSale($sale);
    }
    /**
     * Get sale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaleType[]|null
     */
    public function getSale()
    {
        return isset($this->sale) ? $this->sale : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleForArrayConstraintsFromSetSale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesSaleItem) {
            // validation for constraint: itemType
            if (!$salesSaleItem instanceof \StructType\SaleType) {
                $invalidValues[] = is_object($salesSaleItem) ? get_class($salesSaleItem) : sprintf('%s(%s)', gettype($salesSaleItem), var_export($salesSaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sale property can only contain items of type \StructType\SaleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SaleType[] $sale
     * @return \StructType\Sales
     */
    public function setSale(array $sale = array())
    {
        // validation for constraint: array
        if ('' !== ($saleArrayErrorMessage = self::validateSaleForArrayConstraintsFromSetSale($sale))) {
            throw new \InvalidArgumentException($saleArrayErrorMessage, __LINE__);
        }
        if (is_null($sale) || (is_array($sale) && empty($sale))) {
            unset($this->sale);
        } else {
            $this->sale = $sale;
        }
        return $this;
    }
    /**
     * Add item to sale value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleType $item
     * @return \StructType\Sales
     */
    public function addToSale(\StructType\SaleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleType) {
            throw new \InvalidArgumentException(sprintf('The sale property can only contain items of type \StructType\SaleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sale[] = $item;
        return $this;
    }
}
