<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for penaltySummaryResponse StructType
 * @subpackage Structs
 */
class PenaltySummaryResponse extends BaseResponse
{
    /**
     * The sellerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sellerId;
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleCode;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for penaltySummaryResponse
     * @uses PenaltySummaryResponse::setSellerId()
     * @uses PenaltySummaryResponse::setSaleCode()
     * @uses PenaltySummaryResponse::setAmount()
     * @param int $sellerId
     * @param string $saleCode
     * @param float $amount
     */
    public function __construct($sellerId = null, $saleCode = null, $amount = null)
    {
        $this
            ->setSellerId($sellerId)
            ->setSaleCode($saleCode)
            ->setAmount($amount);
    }
    /**
     * Get sellerId value
     * @return int|null
     */
    public function getSellerId()
    {
        return $this->sellerId;
    }
    /**
     * Set sellerId value
     * @param int $sellerId
     * @return \StructType\PenaltySummaryResponse
     */
    public function setSellerId($sellerId = null)
    {
        // validation for constraint: int
        if (!is_null($sellerId) && !(is_int($sellerId) || ctype_digit($sellerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sellerId, true), gettype($sellerId)), __LINE__);
        }
        $this->sellerId = $sellerId;
        return $this;
    }
    /**
     * Get saleCode value
     * @return string|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * Set saleCode value
     * @param string $saleCode
     * @return \StructType\PenaltySummaryResponse
     */
    public function setSaleCode($saleCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCode) && !is_string($saleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCode, true), gettype($saleCode)), __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PenaltySummaryResponse
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
