<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemBuyers StructType
 * @subpackage Structs
 */
class ItemBuyers extends AbstractStructBase
{
    /**
     * The itemBuyer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaleBuyerType[]
     */
    public $itemBuyer;
    /**
     * Constructor method for itemBuyers
     * @uses ItemBuyers::setItemBuyer()
     * @param \StructType\SaleBuyerType[] $itemBuyer
     */
    public function __construct(array $itemBuyer = array())
    {
        $this
            ->setItemBuyer($itemBuyer);
    }
    /**
     * Get itemBuyer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaleBuyerType[]|null
     */
    public function getItemBuyer()
    {
        return isset($this->itemBuyer) ? $this->itemBuyer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemBuyer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemBuyer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemBuyerForArrayConstraintsFromSetItemBuyer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemBuyersItemBuyerItem) {
            // validation for constraint: itemType
            if (!$itemBuyersItemBuyerItem instanceof \StructType\SaleBuyerType) {
                $invalidValues[] = is_object($itemBuyersItemBuyerItem) ? get_class($itemBuyersItemBuyerItem) : sprintf('%s(%s)', gettype($itemBuyersItemBuyerItem), var_export($itemBuyersItemBuyerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemBuyer property can only contain items of type \StructType\SaleBuyerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemBuyer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SaleBuyerType[] $itemBuyer
     * @return \StructType\ItemBuyers
     */
    public function setItemBuyer(array $itemBuyer = array())
    {
        // validation for constraint: array
        if ('' !== ($itemBuyerArrayErrorMessage = self::validateItemBuyerForArrayConstraintsFromSetItemBuyer($itemBuyer))) {
            throw new \InvalidArgumentException($itemBuyerArrayErrorMessage, __LINE__);
        }
        if (is_null($itemBuyer) || (is_array($itemBuyer) && empty($itemBuyer))) {
            unset($this->itemBuyer);
        } else {
            $this->itemBuyer = $itemBuyer;
        }
        return $this;
    }
    /**
     * Add item to itemBuyer value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleBuyerType $item
     * @return \StructType\ItemBuyers
     */
    public function addToItemBuyer(\StructType\SaleBuyerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleBuyerType) {
            throw new \InvalidArgumentException(sprintf('The itemBuyer property can only contain items of type \StructType\SaleBuyerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemBuyer[] = $item;
        return $this;
    }
}
