<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for imageDto StructType
 * @subpackage Structs
 */
class ImageDto extends AbstractStructBase
{
    /**
     * The imageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $imageId;
    /**
     * The imageUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ImageUrls
     */
    public $imageUrls;
    /**
     * The zoomInSupport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $zoomInSupport;
    /**
     * Constructor method for imageDto
     * @uses ImageDto::setImageId()
     * @uses ImageDto::setImageUrls()
     * @uses ImageDto::setZoomInSupport()
     * @param int $imageId
     * @param \StructType\ImageUrls $imageUrls
     * @param bool $zoomInSupport
     */
    public function __construct($imageId = null, \StructType\ImageUrls $imageUrls = null, $zoomInSupport = null)
    {
        $this
            ->setImageId($imageId)
            ->setImageUrls($imageUrls)
            ->setZoomInSupport($zoomInSupport);
    }
    /**
     * Get imageId value
     * @return int|null
     */
    public function getImageId()
    {
        return $this->imageId;
    }
    /**
     * Set imageId value
     * @param int $imageId
     * @return \StructType\ImageDto
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: int
        if (!is_null($imageId) && !(is_int($imageId) || ctype_digit($imageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        $this->imageId = $imageId;
        return $this;
    }
    /**
     * Get imageUrls value
     * @return \StructType\ImageUrls|null
     */
    public function getImageUrls()
    {
        return $this->imageUrls;
    }
    /**
     * Set imageUrls value
     * @param \StructType\ImageUrls $imageUrls
     * @return \StructType\ImageDto
     */
    public function setImageUrls(\StructType\ImageUrls $imageUrls = null)
    {
        $this->imageUrls = $imageUrls;
        return $this;
    }
    /**
     * Get zoomInSupport value
     * @return bool|null
     */
    public function getZoomInSupport()
    {
        return $this->zoomInSupport;
    }
    /**
     * Set zoomInSupport value
     * @param bool $zoomInSupport
     * @return \StructType\ImageDto
     */
    public function setZoomInSupport($zoomInSupport = null)
    {
        // validation for constraint: boolean
        if (!is_null($zoomInSupport) && !is_bool($zoomInSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zoomInSupport, true), gettype($zoomInSupport)), __LINE__);
        }
        $this->zoomInSupport = $zoomInSupport;
        return $this;
    }
}
