<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftProductInfoDto StructType
 * @subpackage Structs
 */
class GiftProductInfoDto extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The retailVariantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $retailVariantId;
    /**
     * The retailVariant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VariantDto
     */
    public $retailVariant;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The images
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageDto[]
     */
    public $images;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The stockQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $stockQuantity;
    /**
     * The productUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productUrl;
    /**
     * The possibleGiftVariants
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VariantDto[]
     */
    public $possibleGiftVariants;
    /**
     * Constructor method for giftProductInfoDto
     * @uses GiftProductInfoDto::setProductId()
     * @uses GiftProductInfoDto::setRetailVariantId()
     * @uses GiftProductInfoDto::setRetailVariant()
     * @uses GiftProductInfoDto::setType()
     * @uses GiftProductInfoDto::setValue()
     * @uses GiftProductInfoDto::setTitle()
     * @uses GiftProductInfoDto::setImages()
     * @uses GiftProductInfoDto::setStartDate()
     * @uses GiftProductInfoDto::setEndDate()
     * @uses GiftProductInfoDto::setStockQuantity()
     * @uses GiftProductInfoDto::setProductUrl()
     * @uses GiftProductInfoDto::setPossibleGiftVariants()
     * @param int $productId
     * @param int $retailVariantId
     * @param \StructType\VariantDto $retailVariant
     * @param string $type
     * @param float $value
     * @param string $title
     * @param \StructType\ImageDto[] $images
     * @param string $startDate
     * @param string $endDate
     * @param int $stockQuantity
     * @param string $productUrl
     * @param \StructType\VariantDto[] $possibleGiftVariants
     */
    public function __construct($productId = null, $retailVariantId = null, \StructType\VariantDto $retailVariant = null, $type = null, $value = null, $title = null, array $images = array(), $startDate = null, $endDate = null, $stockQuantity = null, $productUrl = null, array $possibleGiftVariants = array())
    {
        $this
            ->setProductId($productId)
            ->setRetailVariantId($retailVariantId)
            ->setRetailVariant($retailVariant)
            ->setType($type)
            ->setValue($value)
            ->setTitle($title)
            ->setImages($images)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setStockQuantity($stockQuantity)
            ->setProductUrl($productUrl)
            ->setPossibleGiftVariants($possibleGiftVariants);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\GiftProductInfoDto
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get retailVariantId value
     * @return int|null
     */
    public function getRetailVariantId()
    {
        return $this->retailVariantId;
    }
    /**
     * Set retailVariantId value
     * @param int $retailVariantId
     * @return \StructType\GiftProductInfoDto
     */
    public function setRetailVariantId($retailVariantId = null)
    {
        // validation for constraint: int
        if (!is_null($retailVariantId) && !(is_int($retailVariantId) || ctype_digit($retailVariantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailVariantId, true), gettype($retailVariantId)), __LINE__);
        }
        $this->retailVariantId = $retailVariantId;
        return $this;
    }
    /**
     * Get retailVariant value
     * @return \StructType\VariantDto|null
     */
    public function getRetailVariant()
    {
        return $this->retailVariant;
    }
    /**
     * Set retailVariant value
     * @param \StructType\VariantDto $retailVariant
     * @return \StructType\GiftProductInfoDto
     */
    public function setRetailVariant(\StructType\VariantDto $retailVariant = null)
    {
        $this->retailVariant = $retailVariant;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\GiftPromotionType::valueIsValid()
     * @uses \EnumType\GiftPromotionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GiftProductInfoDto
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GiftPromotionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GiftPromotionType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\GiftPromotionType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\GiftProductInfoDto
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\GiftProductInfoDto
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ImageDto[]|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * This method is responsible for validating the values passed to the setImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagesForArrayConstraintsFromSetImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftProductInfoDtoImagesItem) {
            // validation for constraint: itemType
            if (!$giftProductInfoDtoImagesItem instanceof \StructType\ImageDto) {
                $invalidValues[] = is_object($giftProductInfoDtoImagesItem) ? get_class($giftProductInfoDtoImagesItem) : sprintf('%s(%s)', gettype($giftProductInfoDtoImagesItem), var_export($giftProductInfoDtoImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The images property can only contain items of type \StructType\ImageDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set images value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageDto[] $images
     * @return \StructType\GiftProductInfoDto
     */
    public function setImages(array $images = array())
    {
        // validation for constraint: array
        if ('' !== ($imagesArrayErrorMessage = self::validateImagesForArrayConstraintsFromSetImages($images))) {
            throw new \InvalidArgumentException($imagesArrayErrorMessage, __LINE__);
        }
        $this->images = $images;
        return $this;
    }
    /**
     * Add item to images value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageDto $item
     * @return \StructType\GiftProductInfoDto
     */
    public function addToImages(\StructType\ImageDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageDto) {
            throw new \InvalidArgumentException(sprintf('The images property can only contain items of type \StructType\ImageDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->images[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GiftProductInfoDto
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\GiftProductInfoDto
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get stockQuantity value
     * @return int|null
     */
    public function getStockQuantity()
    {
        return $this->stockQuantity;
    }
    /**
     * Set stockQuantity value
     * @param int $stockQuantity
     * @return \StructType\GiftProductInfoDto
     */
    public function setStockQuantity($stockQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($stockQuantity) && !(is_int($stockQuantity) || ctype_digit($stockQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockQuantity, true), gettype($stockQuantity)), __LINE__);
        }
        $this->stockQuantity = $stockQuantity;
        return $this;
    }
    /**
     * Get productUrl value
     * @return string|null
     */
    public function getProductUrl()
    {
        return $this->productUrl;
    }
    /**
     * Set productUrl value
     * @param string $productUrl
     * @return \StructType\GiftProductInfoDto
     */
    public function setProductUrl($productUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productUrl) && !is_string($productUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productUrl, true), gettype($productUrl)), __LINE__);
        }
        $this->productUrl = $productUrl;
        return $this;
    }
    /**
     * Get possibleGiftVariants value
     * @return \StructType\VariantDto[]|null
     */
    public function getPossibleGiftVariants()
    {
        return $this->possibleGiftVariants;
    }
    /**
     * This method is responsible for validating the values passed to the setPossibleGiftVariants method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPossibleGiftVariants method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePossibleGiftVariantsForArrayConstraintsFromSetPossibleGiftVariants(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftProductInfoDtoPossibleGiftVariantsItem) {
            // validation for constraint: itemType
            if (!$giftProductInfoDtoPossibleGiftVariantsItem instanceof \StructType\VariantDto) {
                $invalidValues[] = is_object($giftProductInfoDtoPossibleGiftVariantsItem) ? get_class($giftProductInfoDtoPossibleGiftVariantsItem) : sprintf('%s(%s)', gettype($giftProductInfoDtoPossibleGiftVariantsItem), var_export($giftProductInfoDtoPossibleGiftVariantsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The possibleGiftVariants property can only contain items of type \StructType\VariantDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set possibleGiftVariants value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantDto[] $possibleGiftVariants
     * @return \StructType\GiftProductInfoDto
     */
    public function setPossibleGiftVariants(array $possibleGiftVariants = array())
    {
        // validation for constraint: array
        if ('' !== ($possibleGiftVariantsArrayErrorMessage = self::validatePossibleGiftVariantsForArrayConstraintsFromSetPossibleGiftVariants($possibleGiftVariants))) {
            throw new \InvalidArgumentException($possibleGiftVariantsArrayErrorMessage, __LINE__);
        }
        $this->possibleGiftVariants = $possibleGiftVariants;
        return $this;
    }
    /**
     * Add item to possibleGiftVariants value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantDto $item
     * @return \StructType\GiftProductInfoDto
     */
    public function addToPossibleGiftVariants(\StructType\VariantDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VariantDto) {
            throw new \InvalidArgumentException(sprintf('The possibleGiftVariants property can only contain items of type \StructType\VariantDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->possibleGiftVariants[] = $item;
        return $this;
    }
}
