<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for imageUrlDto StructType
 * @subpackage Structs
 */
class ImageUrlDto extends AbstractStructBase
{
    /**
     * The imageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imageUrl;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $size;
    /**
     * Constructor method for imageUrlDto
     * @uses ImageUrlDto::setImageUrl()
     * @uses ImageUrlDto::setSize()
     * @param string $imageUrl
     * @param string $size
     */
    public function __construct($imageUrl = null, $size = null)
    {
        $this
            ->setImageUrl($imageUrl)
            ->setSize($size);
    }
    /**
     * Get imageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->imageUrl;
    }
    /**
     * Set imageUrl value
     * @param string $imageUrl
     * @return \StructType\ImageUrlDto
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->imageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param string $size
     * @return \StructType\ImageUrlDto
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
}
