<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelSale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $reasonId
     * @param string $lang
     * @return \StructType\MessageServiceResponse|bool
     */
    public function cancelSale($apiKey, $sign, $time, $saleCode, $reasonId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelSale($apiKey, $sign, $time, $saleCode, $reasonId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * cancelSaleAfterEarlyCancellationRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $lang
     * @return \StructType\MessageServiceResponse|bool
     */
    public function cancelSaleAfterEarlyCancellationRequest($apiKey, $sign, $time, $saleCode, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelSaleAfterEarlyCancellationRequest($apiKey, $sign, $time, $saleCode, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
