<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeSaleFromList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $userType
     * @param string $lang
     * @return \StructType\MessageServiceResponse|bool
     */
    public function removeSaleFromList($apiKey, $sign, $time, $saleCode, $userType, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSaleFromList($apiKey, $sign, $time, $saleCode, $userType, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
