<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for images StructType
 * @subpackage Structs
 */
class Images extends AbstractStructBase
{
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageDto[]
     */
    public $image;
    /**
     * Constructor method for images
     * @uses Images::setImage()
     * @param \StructType\ImageDto[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get image value
     * @return \StructType\ImageDto[]|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * This method is responsible for validating the values passed to the setImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageForArrayConstraintsFromSetImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imagesImageItem) {
            // validation for constraint: itemType
            if (!$imagesImageItem instanceof \StructType\ImageDto) {
                $invalidValues[] = is_object($imagesImageItem) ? get_class($imagesImageItem) : sprintf('%s(%s)', gettype($imagesImageItem), var_export($imagesImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The image property can only contain items of type \StructType\ImageDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set image value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageDto[] $image
     * @return \StructType\Images
     */
    public function setImage(array $image = array())
    {
        // validation for constraint: array
        if ('' !== ($imageArrayErrorMessage = self::validateImageForArrayConstraintsFromSetImage($image))) {
            throw new \InvalidArgumentException($imageArrayErrorMessage, __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Add item to image value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageDto $item
     * @return \StructType\Images
     */
    public function addToImage(\StructType\ImageDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageDto) {
            throw new \InvalidArgumentException(sprintf('The image property can only contain items of type \StructType\ImageDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->image[] = $item;
        return $this;
    }
}
