<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleServiceResponse StructType
 * @subpackage Structs
 */
class SaleServiceResponse extends BaseResponse
{
    /**
     * The saleCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $saleCount;
    /**
     * The sales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sales
     */
    public $sales;
    /**
     * The sellerPromotionInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SellerPromotionInfos
     */
    public $sellerPromotionInfos;
    /**
     * Constructor method for saleServiceResponse
     * @uses SaleServiceResponse::setSaleCount()
     * @uses SaleServiceResponse::setSales()
     * @uses SaleServiceResponse::setSellerPromotionInfos()
     * @param int $saleCount
     * @param \StructType\Sales $sales
     * @param \StructType\SellerPromotionInfos $sellerPromotionInfos
     */
    public function __construct($saleCount = null, \StructType\Sales $sales = null, \StructType\SellerPromotionInfos $sellerPromotionInfos = null)
    {
        $this
            ->setSaleCount($saleCount)
            ->setSales($sales)
            ->setSellerPromotionInfos($sellerPromotionInfos);
    }
    /**
     * Get saleCount value
     * @return int|null
     */
    public function getSaleCount()
    {
        return $this->saleCount;
    }
    /**
     * Set saleCount value
     * @param int $saleCount
     * @return \StructType\SaleServiceResponse
     */
    public function setSaleCount($saleCount = null)
    {
        // validation for constraint: int
        if (!is_null($saleCount) && !(is_int($saleCount) || ctype_digit($saleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleCount, true), gettype($saleCount)), __LINE__);
        }
        $this->saleCount = $saleCount;
        return $this;
    }
    /**
     * Get sales value
     * @return \StructType\Sales|null
     */
    public function getSales()
    {
        return $this->sales;
    }
    /**
     * Set sales value
     * @param \StructType\Sales $sales
     * @return \StructType\SaleServiceResponse
     */
    public function setSales(\StructType\Sales $sales = null)
    {
        $this->sales = $sales;
        return $this;
    }
    /**
     * Get sellerPromotionInfos value
     * @return \StructType\SellerPromotionInfos|null
     */
    public function getSellerPromotionInfos()
    {
        return $this->sellerPromotionInfos;
    }
    /**
     * Set sellerPromotionInfos value
     * @param \StructType\SellerPromotionInfos $sellerPromotionInfos
     * @return \StructType\SaleServiceResponse
     */
    public function setSellerPromotionInfos(\StructType\SellerPromotionInfos $sellerPromotionInfos = null)
    {
        $this->sellerPromotionInfos = $sellerPromotionInfos;
        return $this;
    }
}
