<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mainProductInfoDto StructType
 * @subpackage Structs
 */
class MainProductInfoDto extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The retailVariantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $retailVariantId;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The images
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Images
     */
    public $images;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The stockQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $stockQuantity;
    /**
     * The productUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productUrl;
    /**
     * Constructor method for mainProductInfoDto
     * @uses MainProductInfoDto::setProductId()
     * @uses MainProductInfoDto::setQuantity()
     * @uses MainProductInfoDto::setRetailVariantId()
     * @uses MainProductInfoDto::setTitle()
     * @uses MainProductInfoDto::setImages()
     * @uses MainProductInfoDto::setStartDate()
     * @uses MainProductInfoDto::setEndDate()
     * @uses MainProductInfoDto::setStockQuantity()
     * @uses MainProductInfoDto::setProductUrl()
     * @param int $productId
     * @param int $quantity
     * @param int $retailVariantId
     * @param string $title
     * @param \StructType\Images $images
     * @param string $startDate
     * @param string $endDate
     * @param int $stockQuantity
     * @param string $productUrl
     */
    public function __construct($productId = null, $quantity = null, $retailVariantId = null, $title = null, \StructType\Images $images = null, $startDate = null, $endDate = null, $stockQuantity = null, $productUrl = null)
    {
        $this
            ->setProductId($productId)
            ->setQuantity($quantity)
            ->setRetailVariantId($retailVariantId)
            ->setTitle($title)
            ->setImages($images)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setStockQuantity($stockQuantity)
            ->setProductUrl($productUrl);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\MainProductInfoDto
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\MainProductInfoDto
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get retailVariantId value
     * @return int|null
     */
    public function getRetailVariantId()
    {
        return $this->retailVariantId;
    }
    /**
     * Set retailVariantId value
     * @param int $retailVariantId
     * @return \StructType\MainProductInfoDto
     */
    public function setRetailVariantId($retailVariantId = null)
    {
        // validation for constraint: int
        if (!is_null($retailVariantId) && !(is_int($retailVariantId) || ctype_digit($retailVariantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailVariantId, true), gettype($retailVariantId)), __LINE__);
        }
        $this->retailVariantId = $retailVariantId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\MainProductInfoDto
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\Images|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\Images $images
     * @return \StructType\MainProductInfoDto
     */
    public function setImages(\StructType\Images $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\MainProductInfoDto
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\MainProductInfoDto
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get stockQuantity value
     * @return int|null
     */
    public function getStockQuantity()
    {
        return $this->stockQuantity;
    }
    /**
     * Set stockQuantity value
     * @param int $stockQuantity
     * @return \StructType\MainProductInfoDto
     */
    public function setStockQuantity($stockQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($stockQuantity) && !(is_int($stockQuantity) || ctype_digit($stockQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockQuantity, true), gettype($stockQuantity)), __LINE__);
        }
        $this->stockQuantity = $stockQuantity;
        return $this;
    }
    /**
     * Get productUrl value
     * @return string|null
     */
    public function getProductUrl()
    {
        return $this->productUrl;
    }
    /**
     * Set productUrl value
     * @param string $productUrl
     * @return \StructType\MainProductInfoDto
     */
    public function setProductUrl($productUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productUrl) && !is_string($productUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productUrl, true), gettype($productUrl)), __LINE__);
        }
        $this->productUrl = $productUrl;
        return $this;
    }
}
