<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantSpecs StructType
 * @subpackage Structs
 */
class VariantSpecs extends AbstractStructBase
{
    /**
     * The variantSpec
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemVariantSpecType[]
     */
    public $variantSpec;
    /**
     * Constructor method for variantSpecs
     * @uses VariantSpecs::setVariantSpec()
     * @param \StructType\ItemVariantSpecType[] $variantSpec
     */
    public function __construct(array $variantSpec = array())
    {
        $this
            ->setVariantSpec($variantSpec);
    }
    /**
     * Get variantSpec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemVariantSpecType[]|null
     */
    public function getVariantSpec()
    {
        return isset($this->variantSpec) ? $this->variantSpec : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVariantSpec method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariantSpec method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariantSpecForArrayConstraintsFromSetVariantSpec(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $variantSpecsVariantSpecItem) {
            // validation for constraint: itemType
            if (!$variantSpecsVariantSpecItem instanceof \StructType\ItemVariantSpecType) {
                $invalidValues[] = is_object($variantSpecsVariantSpecItem) ? get_class($variantSpecsVariantSpecItem) : sprintf('%s(%s)', gettype($variantSpecsVariantSpecItem), var_export($variantSpecsVariantSpecItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variantSpec property can only contain items of type \StructType\ItemVariantSpecType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variantSpec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemVariantSpecType[] $variantSpec
     * @return \StructType\VariantSpecs
     */
    public function setVariantSpec(array $variantSpec = array())
    {
        // validation for constraint: array
        if ('' !== ($variantSpecArrayErrorMessage = self::validateVariantSpecForArrayConstraintsFromSetVariantSpec($variantSpec))) {
            throw new \InvalidArgumentException($variantSpecArrayErrorMessage, __LINE__);
        }
        if (is_null($variantSpec) || (is_array($variantSpec) && empty($variantSpec))) {
            unset($this->variantSpec);
        } else {
            $this->variantSpec = $variantSpec;
        }
        return $this;
    }
    /**
     * Add item to variantSpec value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemVariantSpecType $item
     * @return \StructType\VariantSpecs
     */
    public function addToVariantSpec(\StructType\ItemVariantSpecType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemVariantSpecType) {
            throw new \InvalidArgumentException(sprintf('The variantSpec property can only contain items of type \StructType\ItemVariantSpecType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variantSpec[] = $item;
        return $this;
    }
}
