<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for commissions StructType
 * @subpackage Structs
 */
class Commissions extends AbstractStructBase
{
    /**
     * The commission
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountTransactionFvfCommissionType[]
     */
    public $commission;
    /**
     * Constructor method for commissions
     * @uses Commissions::setCommission()
     * @param \StructType\AccountTransactionFvfCommissionType[] $commission
     */
    public function __construct(array $commission = array())
    {
        $this
            ->setCommission($commission);
    }
    /**
     * Get commission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountTransactionFvfCommissionType[]|null
     */
    public function getCommission()
    {
        return isset($this->commission) ? $this->commission : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commissionsCommissionItem) {
            // validation for constraint: itemType
            if (!$commissionsCommissionItem instanceof \StructType\AccountTransactionFvfCommissionType) {
                $invalidValues[] = is_object($commissionsCommissionItem) ? get_class($commissionsCommissionItem) : sprintf('%s(%s)', gettype($commissionsCommissionItem), var_export($commissionsCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The commission property can only contain items of type \StructType\AccountTransactionFvfCommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set commission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountTransactionFvfCommissionType[] $commission
     * @return \StructType\Commissions
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        if (is_null($commission) || (is_array($commission) && empty($commission))) {
            unset($this->commission);
        } else {
            $this->commission = $commission;
        }
        return $this;
    }
    /**
     * Add item to commission value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountTransactionFvfCommissionType $item
     * @return \StructType\Commissions
     */
    public function addToCommission(\StructType\AccountTransactionFvfCommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountTransactionFvfCommissionType) {
            throw new \InvalidArgumentException(sprintf('The commission property can only contain items of type \StructType\AccountTransactionFvfCommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->commission[] = $item;
        return $this;
    }
}
