<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for errorType StructType
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The errorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorId;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The viewMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $viewMessage;
    /**
     * Constructor method for errorType
     * @uses ErrorType::setErrorId()
     * @uses ErrorType::setErrorCode()
     * @uses ErrorType::setMessage()
     * @uses ErrorType::setViewMessage()
     * @param string $errorId
     * @param string $errorCode
     * @param string $message
     * @param string $viewMessage
     */
    public function __construct($errorId = null, $errorCode = null, $message = null, $viewMessage = null)
    {
        $this
            ->setErrorId($errorId)
            ->setErrorCode($errorCode)
            ->setMessage($message)
            ->setViewMessage($viewMessage);
    }
    /**
     * Get errorId value
     * @return string|null
     */
    public function getErrorId()
    {
        return $this->errorId;
    }
    /**
     * Set errorId value
     * @param string $errorId
     * @return \StructType\ErrorType
     */
    public function setErrorId($errorId = null)
    {
        // validation for constraint: string
        if (!is_null($errorId) && !is_string($errorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorId, true), gettype($errorId)), __LINE__);
        }
        $this->errorId = $errorId;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\ErrorType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ErrorType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get viewMessage value
     * @return string|null
     */
    public function getViewMessage()
    {
        return $this->viewMessage;
    }
    /**
     * Set viewMessage value
     * @param string $viewMessage
     * @return \StructType\ErrorType
     */
    public function setViewMessage($viewMessage = null)
    {
        // validation for constraint: string
        if (!is_null($viewMessage) && !is_string($viewMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewMessage, true), gettype($viewMessage)), __LINE__);
        }
        $this->viewMessage = $viewMessage;
        return $this;
    }
}
