<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reply ServiceType
 * @subpackage Services
 */
class Reply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named replySaleComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $userType
     * @param string $productId
     * @param string $comment
     * @param string $lang
     * @return \StructType\CommonSaleResponse|bool
     */
    public function replySaleComment($apiKey, $sign, $time, $userType, $productId, $comment, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->replySaleComment($apiKey, $sign, $time, $userType, $productId, $comment, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CommonSaleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
