<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sellerPromotionItem StructType
 * @subpackage Structs
 */
class SellerPromotionItem extends AbstractStructBase
{
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The mainProducts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MainProducts
     */
    public $mainProducts;
    /**
     * The gifts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Gifts
     */
    public $gifts;
    /**
     * Constructor method for sellerPromotionItem
     * @uses SellerPromotionItem::setItemId()
     * @uses SellerPromotionItem::setMainProducts()
     * @uses SellerPromotionItem::setGifts()
     * @param string $itemId
     * @param \StructType\MainProducts $mainProducts
     * @param \StructType\Gifts $gifts
     */
    public function __construct($itemId = null, \StructType\MainProducts $mainProducts = null, \StructType\Gifts $gifts = null)
    {
        $this
            ->setItemId($itemId)
            ->setMainProducts($mainProducts)
            ->setGifts($gifts);
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\SellerPromotionItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get mainProducts value
     * @return \StructType\MainProducts|null
     */
    public function getMainProducts()
    {
        return $this->mainProducts;
    }
    /**
     * Set mainProducts value
     * @param \StructType\MainProducts $mainProducts
     * @return \StructType\SellerPromotionItem
     */
    public function setMainProducts(\StructType\MainProducts $mainProducts = null)
    {
        $this->mainProducts = $mainProducts;
        return $this;
    }
    /**
     * Get gifts value
     * @return \StructType\Gifts|null
     */
    public function getGifts()
    {
        return $this->gifts;
    }
    /**
     * Set gifts value
     * @param \StructType\Gifts $gifts
     * @return \StructType\SellerPromotionItem
     */
    public function setGifts(\StructType\Gifts $gifts = null)
    {
        $this->gifts = $gifts;
        return $this;
    }
}
