<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleSellerPromotionType StructType
 * @subpackage Structs
 */
class SaleSellerPromotionType extends AbstractStructBase
{
    /**
     * The discountedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountedPrice;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The productUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productUrl;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The retailVariantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $retailVariantId;
    /**
     * The saleSellerPromotionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $saleSellerPromotionId;
    /**
     * The sellerPromotion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SellerPromotion
     */
    public $sellerPromotion;
    /**
     * Constructor method for saleSellerPromotionType
     * @uses SaleSellerPromotionType::setDiscountedPrice()
     * @uses SaleSellerPromotionType::setPrice()
     * @uses SaleSellerPromotionType::setProductId()
     * @uses SaleSellerPromotionType::setProductUrl()
     * @uses SaleSellerPromotionType::setTitle()
     * @uses SaleSellerPromotionType::setQuantity()
     * @uses SaleSellerPromotionType::setRetailVariantId()
     * @uses SaleSellerPromotionType::setSaleSellerPromotionId()
     * @uses SaleSellerPromotionType::setSellerPromotion()
     * @param float $discountedPrice
     * @param float $price
     * @param int $productId
     * @param string $productUrl
     * @param string $title
     * @param int $quantity
     * @param int $retailVariantId
     * @param int $saleSellerPromotionId
     * @param \StructType\SellerPromotion $sellerPromotion
     */
    public function __construct($discountedPrice = null, $price = null, $productId = null, $productUrl = null, $title = null, $quantity = null, $retailVariantId = null, $saleSellerPromotionId = null, \StructType\SellerPromotion $sellerPromotion = null)
    {
        $this
            ->setDiscountedPrice($discountedPrice)
            ->setPrice($price)
            ->setProductId($productId)
            ->setProductUrl($productUrl)
            ->setTitle($title)
            ->setQuantity($quantity)
            ->setRetailVariantId($retailVariantId)
            ->setSaleSellerPromotionId($saleSellerPromotionId)
            ->setSellerPromotion($sellerPromotion);
    }
    /**
     * Get discountedPrice value
     * @return float|null
     */
    public function getDiscountedPrice()
    {
        return $this->discountedPrice;
    }
    /**
     * Set discountedPrice value
     * @param float $discountedPrice
     * @return \StructType\SaleSellerPromotionType
     */
    public function setDiscountedPrice($discountedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($discountedPrice) && !(is_float($discountedPrice) || is_numeric($discountedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountedPrice, true), gettype($discountedPrice)), __LINE__);
        }
        $this->discountedPrice = $discountedPrice;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\SaleSellerPromotionType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\SaleSellerPromotionType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productUrl value
     * @return string|null
     */
    public function getProductUrl()
    {
        return $this->productUrl;
    }
    /**
     * Set productUrl value
     * @param string $productUrl
     * @return \StructType\SaleSellerPromotionType
     */
    public function setProductUrl($productUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productUrl) && !is_string($productUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productUrl, true), gettype($productUrl)), __LINE__);
        }
        $this->productUrl = $productUrl;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\SaleSellerPromotionType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\SaleSellerPromotionType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get retailVariantId value
     * @return int|null
     */
    public function getRetailVariantId()
    {
        return $this->retailVariantId;
    }
    /**
     * Set retailVariantId value
     * @param int $retailVariantId
     * @return \StructType\SaleSellerPromotionType
     */
    public function setRetailVariantId($retailVariantId = null)
    {
        // validation for constraint: int
        if (!is_null($retailVariantId) && !(is_int($retailVariantId) || ctype_digit($retailVariantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailVariantId, true), gettype($retailVariantId)), __LINE__);
        }
        $this->retailVariantId = $retailVariantId;
        return $this;
    }
    /**
     * Get saleSellerPromotionId value
     * @return int|null
     */
    public function getSaleSellerPromotionId()
    {
        return $this->saleSellerPromotionId;
    }
    /**
     * Set saleSellerPromotionId value
     * @param int $saleSellerPromotionId
     * @return \StructType\SaleSellerPromotionType
     */
    public function setSaleSellerPromotionId($saleSellerPromotionId = null)
    {
        // validation for constraint: int
        if (!is_null($saleSellerPromotionId) && !(is_int($saleSellerPromotionId) || ctype_digit($saleSellerPromotionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleSellerPromotionId, true), gettype($saleSellerPromotionId)), __LINE__);
        }
        $this->saleSellerPromotionId = $saleSellerPromotionId;
        return $this;
    }
    /**
     * Get sellerPromotion value
     * @return \StructType\SellerPromotion|null
     */
    public function getSellerPromotion()
    {
        return $this->sellerPromotion;
    }
    /**
     * Set sellerPromotion value
     * @param \StructType\SellerPromotion $sellerPromotion
     * @return \StructType\SaleSellerPromotionType
     */
    public function setSellerPromotion(\StructType\SellerPromotion $sellerPromotion = null)
    {
        $this->sellerPromotion = $sellerPromotion;
        return $this;
    }
}
