<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleProcessType StructType
 * @subpackage Structs
 */
class SaleProcessType extends AbstractStructBase
{
    /**
     * The dailyOfferCommissionRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $dailyOfferCommissionRevenue;
    /**
     * The dailyOfferCommissionRevenueVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $dailyOfferCommissionRevenueVatAmount;
    /**
     * The dailyOfferCommissionRevenueVatBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $dailyOfferCommissionRevenueVatBasis;
    /**
     * The ggCommissionRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ggCommissionRevenue;
    /**
     * The ggCommissionRevenueVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ggCommissionRevenueVatAmount;
    /**
     * The ggCommissionRevenueVatBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ggCommissionRevenueVatBasis;
    /**
     * The ggRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ggRevenue;
    /**
     * The installmentRevenueVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $installmentRevenueVatAmount;
    /**
     * The installmentRevenueVatBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $installmentRevenueVatBasis;
    /**
     * The paidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $paidAmount;
    /**
     * The paymentChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentChannel;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleCode;
    /**
     * The saleDiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $saleDiscountAmount;
    /**
     * The sellerAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sellerAmount;
    /**
     * The sellerBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sellerBalance;
    /**
     * The srsCompleteTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $srsCompleteTime;
    /**
     * The totalMerchantCommissionCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalMerchantCommissionCost;
    /**
     * The transferStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transferStatus;
    /**
     * Constructor method for saleProcessType
     * @uses SaleProcessType::setDailyOfferCommissionRevenue()
     * @uses SaleProcessType::setDailyOfferCommissionRevenueVatAmount()
     * @uses SaleProcessType::setDailyOfferCommissionRevenueVatBasis()
     * @uses SaleProcessType::setGgCommissionRevenue()
     * @uses SaleProcessType::setGgCommissionRevenueVatAmount()
     * @uses SaleProcessType::setGgCommissionRevenueVatBasis()
     * @uses SaleProcessType::setGgRevenue()
     * @uses SaleProcessType::setInstallmentRevenueVatAmount()
     * @uses SaleProcessType::setInstallmentRevenueVatBasis()
     * @uses SaleProcessType::setPaidAmount()
     * @uses SaleProcessType::setPaymentChannel()
     * @uses SaleProcessType::setPrice()
     * @uses SaleProcessType::setSaleCode()
     * @uses SaleProcessType::setSaleDiscountAmount()
     * @uses SaleProcessType::setSellerAmount()
     * @uses SaleProcessType::setSellerBalance()
     * @uses SaleProcessType::setSrsCompleteTime()
     * @uses SaleProcessType::setTotalMerchantCommissionCost()
     * @uses SaleProcessType::setTransferStatus()
     * @param float $dailyOfferCommissionRevenue
     * @param float $dailyOfferCommissionRevenueVatAmount
     * @param float $dailyOfferCommissionRevenueVatBasis
     * @param float $ggCommissionRevenue
     * @param float $ggCommissionRevenueVatAmount
     * @param float $ggCommissionRevenueVatBasis
     * @param float $ggRevenue
     * @param float $installmentRevenueVatAmount
     * @param float $installmentRevenueVatBasis
     * @param float $paidAmount
     * @param string $paymentChannel
     * @param float $price
     * @param string $saleCode
     * @param float $saleDiscountAmount
     * @param float $sellerAmount
     * @param float $sellerBalance
     * @param string $srsCompleteTime
     * @param float $totalMerchantCommissionCost
     * @param string $transferStatus
     */
    public function __construct($dailyOfferCommissionRevenue = null, $dailyOfferCommissionRevenueVatAmount = null, $dailyOfferCommissionRevenueVatBasis = null, $ggCommissionRevenue = null, $ggCommissionRevenueVatAmount = null, $ggCommissionRevenueVatBasis = null, $ggRevenue = null, $installmentRevenueVatAmount = null, $installmentRevenueVatBasis = null, $paidAmount = null, $paymentChannel = null, $price = null, $saleCode = null, $saleDiscountAmount = null, $sellerAmount = null, $sellerBalance = null, $srsCompleteTime = null, $totalMerchantCommissionCost = null, $transferStatus = null)
    {
        $this
            ->setDailyOfferCommissionRevenue($dailyOfferCommissionRevenue)
            ->setDailyOfferCommissionRevenueVatAmount($dailyOfferCommissionRevenueVatAmount)
            ->setDailyOfferCommissionRevenueVatBasis($dailyOfferCommissionRevenueVatBasis)
            ->setGgCommissionRevenue($ggCommissionRevenue)
            ->setGgCommissionRevenueVatAmount($ggCommissionRevenueVatAmount)
            ->setGgCommissionRevenueVatBasis($ggCommissionRevenueVatBasis)
            ->setGgRevenue($ggRevenue)
            ->setInstallmentRevenueVatAmount($installmentRevenueVatAmount)
            ->setInstallmentRevenueVatBasis($installmentRevenueVatBasis)
            ->setPaidAmount($paidAmount)
            ->setPaymentChannel($paymentChannel)
            ->setPrice($price)
            ->setSaleCode($saleCode)
            ->setSaleDiscountAmount($saleDiscountAmount)
            ->setSellerAmount($sellerAmount)
            ->setSellerBalance($sellerBalance)
            ->setSrsCompleteTime($srsCompleteTime)
            ->setTotalMerchantCommissionCost($totalMerchantCommissionCost)
            ->setTransferStatus($transferStatus);
    }
    /**
     * Get dailyOfferCommissionRevenue value
     * @return float|null
     */
    public function getDailyOfferCommissionRevenue()
    {
        return $this->dailyOfferCommissionRevenue;
    }
    /**
     * Set dailyOfferCommissionRevenue value
     * @param float $dailyOfferCommissionRevenue
     * @return \StructType\SaleProcessType
     */
    public function setDailyOfferCommissionRevenue($dailyOfferCommissionRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($dailyOfferCommissionRevenue) && !(is_float($dailyOfferCommissionRevenue) || is_numeric($dailyOfferCommissionRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dailyOfferCommissionRevenue, true), gettype($dailyOfferCommissionRevenue)), __LINE__);
        }
        $this->dailyOfferCommissionRevenue = $dailyOfferCommissionRevenue;
        return $this;
    }
    /**
     * Get dailyOfferCommissionRevenueVatAmount value
     * @return float|null
     */
    public function getDailyOfferCommissionRevenueVatAmount()
    {
        return $this->dailyOfferCommissionRevenueVatAmount;
    }
    /**
     * Set dailyOfferCommissionRevenueVatAmount value
     * @param float $dailyOfferCommissionRevenueVatAmount
     * @return \StructType\SaleProcessType
     */
    public function setDailyOfferCommissionRevenueVatAmount($dailyOfferCommissionRevenueVatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dailyOfferCommissionRevenueVatAmount) && !(is_float($dailyOfferCommissionRevenueVatAmount) || is_numeric($dailyOfferCommissionRevenueVatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dailyOfferCommissionRevenueVatAmount, true), gettype($dailyOfferCommissionRevenueVatAmount)), __LINE__);
        }
        $this->dailyOfferCommissionRevenueVatAmount = $dailyOfferCommissionRevenueVatAmount;
        return $this;
    }
    /**
     * Get dailyOfferCommissionRevenueVatBasis value
     * @return float|null
     */
    public function getDailyOfferCommissionRevenueVatBasis()
    {
        return $this->dailyOfferCommissionRevenueVatBasis;
    }
    /**
     * Set dailyOfferCommissionRevenueVatBasis value
     * @param float $dailyOfferCommissionRevenueVatBasis
     * @return \StructType\SaleProcessType
     */
    public function setDailyOfferCommissionRevenueVatBasis($dailyOfferCommissionRevenueVatBasis = null)
    {
        // validation for constraint: float
        if (!is_null($dailyOfferCommissionRevenueVatBasis) && !(is_float($dailyOfferCommissionRevenueVatBasis) || is_numeric($dailyOfferCommissionRevenueVatBasis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dailyOfferCommissionRevenueVatBasis, true), gettype($dailyOfferCommissionRevenueVatBasis)), __LINE__);
        }
        $this->dailyOfferCommissionRevenueVatBasis = $dailyOfferCommissionRevenueVatBasis;
        return $this;
    }
    /**
     * Get ggCommissionRevenue value
     * @return float|null
     */
    public function getGgCommissionRevenue()
    {
        return $this->ggCommissionRevenue;
    }
    /**
     * Set ggCommissionRevenue value
     * @param float $ggCommissionRevenue
     * @return \StructType\SaleProcessType
     */
    public function setGgCommissionRevenue($ggCommissionRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($ggCommissionRevenue) && !(is_float($ggCommissionRevenue) || is_numeric($ggCommissionRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ggCommissionRevenue, true), gettype($ggCommissionRevenue)), __LINE__);
        }
        $this->ggCommissionRevenue = $ggCommissionRevenue;
        return $this;
    }
    /**
     * Get ggCommissionRevenueVatAmount value
     * @return float|null
     */
    public function getGgCommissionRevenueVatAmount()
    {
        return $this->ggCommissionRevenueVatAmount;
    }
    /**
     * Set ggCommissionRevenueVatAmount value
     * @param float $ggCommissionRevenueVatAmount
     * @return \StructType\SaleProcessType
     */
    public function setGgCommissionRevenueVatAmount($ggCommissionRevenueVatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ggCommissionRevenueVatAmount) && !(is_float($ggCommissionRevenueVatAmount) || is_numeric($ggCommissionRevenueVatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ggCommissionRevenueVatAmount, true), gettype($ggCommissionRevenueVatAmount)), __LINE__);
        }
        $this->ggCommissionRevenueVatAmount = $ggCommissionRevenueVatAmount;
        return $this;
    }
    /**
     * Get ggCommissionRevenueVatBasis value
     * @return float|null
     */
    public function getGgCommissionRevenueVatBasis()
    {
        return $this->ggCommissionRevenueVatBasis;
    }
    /**
     * Set ggCommissionRevenueVatBasis value
     * @param float $ggCommissionRevenueVatBasis
     * @return \StructType\SaleProcessType
     */
    public function setGgCommissionRevenueVatBasis($ggCommissionRevenueVatBasis = null)
    {
        // validation for constraint: float
        if (!is_null($ggCommissionRevenueVatBasis) && !(is_float($ggCommissionRevenueVatBasis) || is_numeric($ggCommissionRevenueVatBasis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ggCommissionRevenueVatBasis, true), gettype($ggCommissionRevenueVatBasis)), __LINE__);
        }
        $this->ggCommissionRevenueVatBasis = $ggCommissionRevenueVatBasis;
        return $this;
    }
    /**
     * Get ggRevenue value
     * @return float|null
     */
    public function getGgRevenue()
    {
        return $this->ggRevenue;
    }
    /**
     * Set ggRevenue value
     * @param float $ggRevenue
     * @return \StructType\SaleProcessType
     */
    public function setGgRevenue($ggRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($ggRevenue) && !(is_float($ggRevenue) || is_numeric($ggRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ggRevenue, true), gettype($ggRevenue)), __LINE__);
        }
        $this->ggRevenue = $ggRevenue;
        return $this;
    }
    /**
     * Get installmentRevenueVatAmount value
     * @return float|null
     */
    public function getInstallmentRevenueVatAmount()
    {
        return $this->installmentRevenueVatAmount;
    }
    /**
     * Set installmentRevenueVatAmount value
     * @param float $installmentRevenueVatAmount
     * @return \StructType\SaleProcessType
     */
    public function setInstallmentRevenueVatAmount($installmentRevenueVatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($installmentRevenueVatAmount) && !(is_float($installmentRevenueVatAmount) || is_numeric($installmentRevenueVatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentRevenueVatAmount, true), gettype($installmentRevenueVatAmount)), __LINE__);
        }
        $this->installmentRevenueVatAmount = $installmentRevenueVatAmount;
        return $this;
    }
    /**
     * Get installmentRevenueVatBasis value
     * @return float|null
     */
    public function getInstallmentRevenueVatBasis()
    {
        return $this->installmentRevenueVatBasis;
    }
    /**
     * Set installmentRevenueVatBasis value
     * @param float $installmentRevenueVatBasis
     * @return \StructType\SaleProcessType
     */
    public function setInstallmentRevenueVatBasis($installmentRevenueVatBasis = null)
    {
        // validation for constraint: float
        if (!is_null($installmentRevenueVatBasis) && !(is_float($installmentRevenueVatBasis) || is_numeric($installmentRevenueVatBasis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentRevenueVatBasis, true), gettype($installmentRevenueVatBasis)), __LINE__);
        }
        $this->installmentRevenueVatBasis = $installmentRevenueVatBasis;
        return $this;
    }
    /**
     * Get paidAmount value
     * @return float|null
     */
    public function getPaidAmount()
    {
        return $this->paidAmount;
    }
    /**
     * Set paidAmount value
     * @param float $paidAmount
     * @return \StructType\SaleProcessType
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paidAmount) && !(is_float($paidAmount) || is_numeric($paidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->paidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get paymentChannel value
     * @return string|null
     */
    public function getPaymentChannel()
    {
        return $this->paymentChannel;
    }
    /**
     * Set paymentChannel value
     * @uses \EnumType\OrderTransactionChannelType::valueIsValid()
     * @uses \EnumType\OrderTransactionChannelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentChannel
     * @return \StructType\SaleProcessType
     */
    public function setPaymentChannel($paymentChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderTransactionChannelType::valueIsValid($paymentChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderTransactionChannelType', is_array($paymentChannel) ? implode(', ', $paymentChannel) : var_export($paymentChannel, true), implode(', ', \EnumType\OrderTransactionChannelType::getValidValues())), __LINE__);
        }
        $this->paymentChannel = $paymentChannel;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\SaleProcessType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get saleCode value
     * @return string|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * Set saleCode value
     * @param string $saleCode
     * @return \StructType\SaleProcessType
     */
    public function setSaleCode($saleCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCode) && !is_string($saleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCode, true), gettype($saleCode)), __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Get saleDiscountAmount value
     * @return float|null
     */
    public function getSaleDiscountAmount()
    {
        return $this->saleDiscountAmount;
    }
    /**
     * Set saleDiscountAmount value
     * @param float $saleDiscountAmount
     * @return \StructType\SaleProcessType
     */
    public function setSaleDiscountAmount($saleDiscountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($saleDiscountAmount) && !(is_float($saleDiscountAmount) || is_numeric($saleDiscountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleDiscountAmount, true), gettype($saleDiscountAmount)), __LINE__);
        }
        $this->saleDiscountAmount = $saleDiscountAmount;
        return $this;
    }
    /**
     * Get sellerAmount value
     * @return float|null
     */
    public function getSellerAmount()
    {
        return $this->sellerAmount;
    }
    /**
     * Set sellerAmount value
     * @param float $sellerAmount
     * @return \StructType\SaleProcessType
     */
    public function setSellerAmount($sellerAmount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerAmount) && !(is_float($sellerAmount) || is_numeric($sellerAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerAmount, true), gettype($sellerAmount)), __LINE__);
        }
        $this->sellerAmount = $sellerAmount;
        return $this;
    }
    /**
     * Get sellerBalance value
     * @return float|null
     */
    public function getSellerBalance()
    {
        return $this->sellerBalance;
    }
    /**
     * Set sellerBalance value
     * @param float $sellerBalance
     * @return \StructType\SaleProcessType
     */
    public function setSellerBalance($sellerBalance = null)
    {
        // validation for constraint: float
        if (!is_null($sellerBalance) && !(is_float($sellerBalance) || is_numeric($sellerBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerBalance, true), gettype($sellerBalance)), __LINE__);
        }
        $this->sellerBalance = $sellerBalance;
        return $this;
    }
    /**
     * Get srsCompleteTime value
     * @return string|null
     */
    public function getSrsCompleteTime()
    {
        return $this->srsCompleteTime;
    }
    /**
     * Set srsCompleteTime value
     * @param string $srsCompleteTime
     * @return \StructType\SaleProcessType
     */
    public function setSrsCompleteTime($srsCompleteTime = null)
    {
        // validation for constraint: string
        if (!is_null($srsCompleteTime) && !is_string($srsCompleteTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srsCompleteTime, true), gettype($srsCompleteTime)), __LINE__);
        }
        $this->srsCompleteTime = $srsCompleteTime;
        return $this;
    }
    /**
     * Get totalMerchantCommissionCost value
     * @return float|null
     */
    public function getTotalMerchantCommissionCost()
    {
        return $this->totalMerchantCommissionCost;
    }
    /**
     * Set totalMerchantCommissionCost value
     * @param float $totalMerchantCommissionCost
     * @return \StructType\SaleProcessType
     */
    public function setTotalMerchantCommissionCost($totalMerchantCommissionCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalMerchantCommissionCost) && !(is_float($totalMerchantCommissionCost) || is_numeric($totalMerchantCommissionCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalMerchantCommissionCost, true), gettype($totalMerchantCommissionCost)), __LINE__);
        }
        $this->totalMerchantCommissionCost = $totalMerchantCommissionCost;
        return $this;
    }
    /**
     * Get transferStatus value
     * @return string|null
     */
    public function getTransferStatus()
    {
        return $this->transferStatus;
    }
    /**
     * Set transferStatus value
     * @uses \EnumType\SrsProcessTransferStatusType::valueIsValid()
     * @uses \EnumType\SrsProcessTransferStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\SaleProcessType
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SrsProcessTransferStatusType::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SrsProcessTransferStatusType', is_array($transferStatus) ? implode(', ', $transferStatus) : var_export($transferStatus, true), implode(', ', \EnumType\SrsProcessTransferStatusType::getValidValues())), __LINE__);
        }
        $this->transferStatus = $transferStatus;
        return $this;
    }
}
