<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleServiceBuyerResponse StructType
 * @subpackage Structs
 */
class SaleServiceBuyerResponse extends BaseResponse
{
    /**
     * The totalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalCount;
    /**
     * The count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The itemBuyers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemBuyers
     */
    public $itemBuyers;
    /**
     * Constructor method for saleServiceBuyerResponse
     * @uses SaleServiceBuyerResponse::setTotalCount()
     * @uses SaleServiceBuyerResponse::setCount()
     * @uses SaleServiceBuyerResponse::setItemBuyers()
     * @param int $totalCount
     * @param int $count
     * @param \StructType\ItemBuyers $itemBuyers
     */
    public function __construct($totalCount = null, $count = null, \StructType\ItemBuyers $itemBuyers = null)
    {
        $this
            ->setTotalCount($totalCount)
            ->setCount($count)
            ->setItemBuyers($itemBuyers);
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\SaleServiceBuyerResponse
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\SaleServiceBuyerResponse
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get itemBuyers value
     * @return \StructType\ItemBuyers|null
     */
    public function getItemBuyers()
    {
        return $this->itemBuyers;
    }
    /**
     * Set itemBuyers value
     * @param \StructType\ItemBuyers $itemBuyers
     * @return \StructType\SaleServiceBuyerResponse
     */
    public function setItemBuyers(\StructType\ItemBuyers $itemBuyers = null)
    {
        $this->itemBuyers = $itemBuyers;
        return $this;
    }
}
