<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gifts StructType
 * @subpackage Structs
 */
class Gifts extends AbstractStructBase
{
    /**
     * The gift
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GiftProductInfoDto[]
     */
    public $gift;
    /**
     * Constructor method for gifts
     * @uses Gifts::setGift()
     * @param \StructType\GiftProductInfoDto[] $gift
     */
    public function __construct(array $gift = array())
    {
        $this
            ->setGift($gift);
    }
    /**
     * Get gift value
     * @return \StructType\GiftProductInfoDto[]|null
     */
    public function getGift()
    {
        return $this->gift;
    }
    /**
     * This method is responsible for validating the values passed to the setGift method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGift method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGiftForArrayConstraintsFromSetGift(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftsGiftItem) {
            // validation for constraint: itemType
            if (!$giftsGiftItem instanceof \StructType\GiftProductInfoDto) {
                $invalidValues[] = is_object($giftsGiftItem) ? get_class($giftsGiftItem) : sprintf('%s(%s)', gettype($giftsGiftItem), var_export($giftsGiftItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gift property can only contain items of type \StructType\GiftProductInfoDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gift value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftProductInfoDto[] $gift
     * @return \StructType\Gifts
     */
    public function setGift(array $gift = array())
    {
        // validation for constraint: array
        if ('' !== ($giftArrayErrorMessage = self::validateGiftForArrayConstraintsFromSetGift($gift))) {
            throw new \InvalidArgumentException($giftArrayErrorMessage, __LINE__);
        }
        $this->gift = $gift;
        return $this;
    }
    /**
     * Add item to gift value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftProductInfoDto $item
     * @return \StructType\Gifts
     */
    public function addToGift(\StructType\GiftProductInfoDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GiftProductInfoDto) {
            throw new \InvalidArgumentException(sprintf('The gift property can only contain items of type \StructType\GiftProductInfoDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gift[] = $item;
        return $this;
    }
}
