<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemVariantSpecType StructType
 * @subpackage Structs
 */
class ItemVariantSpecType extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The soldQuantity
     * @var int
     */
    public $soldQuantity;
    /**
     * The stockCode
     * @var string
     */
    public $stockCode;
    /**
     * Constructor method for itemVariantSpecType
     * @uses ItemVariantSpecType::setName()
     * @uses ItemVariantSpecType::setValue()
     * @uses ItemVariantSpecType::setQuantity()
     * @uses ItemVariantSpecType::setSoldQuantity()
     * @uses ItemVariantSpecType::setStockCode()
     * @param string $name
     * @param string $value
     * @param int $quantity
     * @param int $soldQuantity
     * @param string $stockCode
     */
    public function __construct($name = null, $value = null, $quantity = null, $soldQuantity = null, $stockCode = null)
    {
        $this
            ->setName($name)
            ->setValue($value)
            ->setQuantity($quantity)
            ->setSoldQuantity($soldQuantity)
            ->setStockCode($stockCode);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ItemVariantSpecType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\ItemVariantSpecType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ItemVariantSpecType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get soldQuantity value
     * @return int|null
     */
    public function getSoldQuantity()
    {
        return $this->soldQuantity;
    }
    /**
     * Set soldQuantity value
     * @param int $soldQuantity
     * @return \StructType\ItemVariantSpecType
     */
    public function setSoldQuantity($soldQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($soldQuantity) && !(is_int($soldQuantity) || ctype_digit($soldQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldQuantity, true), gettype($soldQuantity)), __LINE__);
        }
        $this->soldQuantity = $soldQuantity;
        return $this;
    }
    /**
     * Get stockCode value
     * @return string|null
     */
    public function getStockCode()
    {
        return $this->stockCode;
    }
    /**
     * Set stockCode value
     * @param string $stockCode
     * @return \StructType\ItemVariantSpecType
     */
    public function setStockCode($stockCode = null)
    {
        // validation for constraint: string
        if (!is_null($stockCode) && !is_string($stockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockCode, true), gettype($stockCode)), __LINE__);
        }
        $this->stockCode = $stockCode;
        return $this;
    }
}
