<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mainProducts StructType
 * @subpackage Structs
 */
class MainProducts extends AbstractStructBase
{
    /**
     * The mainProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MainProductInfoDto[]
     */
    public $mainProduct;
    /**
     * Constructor method for mainProducts
     * @uses MainProducts::setMainProduct()
     * @param \StructType\MainProductInfoDto[] $mainProduct
     */
    public function __construct(array $mainProduct = array())
    {
        $this
            ->setMainProduct($mainProduct);
    }
    /**
     * Get mainProduct value
     * @return \StructType\MainProductInfoDto[]|null
     */
    public function getMainProduct()
    {
        return $this->mainProduct;
    }
    /**
     * This method is responsible for validating the values passed to the setMainProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMainProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMainProductForArrayConstraintsFromSetMainProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainProductsMainProductItem) {
            // validation for constraint: itemType
            if (!$mainProductsMainProductItem instanceof \StructType\MainProductInfoDto) {
                $invalidValues[] = is_object($mainProductsMainProductItem) ? get_class($mainProductsMainProductItem) : sprintf('%s(%s)', gettype($mainProductsMainProductItem), var_export($mainProductsMainProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mainProduct property can only contain items of type \StructType\MainProductInfoDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mainProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\MainProductInfoDto[] $mainProduct
     * @return \StructType\MainProducts
     */
    public function setMainProduct(array $mainProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($mainProductArrayErrorMessage = self::validateMainProductForArrayConstraintsFromSetMainProduct($mainProduct))) {
            throw new \InvalidArgumentException($mainProductArrayErrorMessage, __LINE__);
        }
        $this->mainProduct = $mainProduct;
        return $this;
    }
    /**
     * Add item to mainProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\MainProductInfoDto $item
     * @return \StructType\MainProducts
     */
    public function addToMainProduct(\StructType\MainProductInfoDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MainProductInfoDto) {
            throw new \InvalidArgumentException(sprintf('The mainProduct property can only contain items of type \StructType\MainProductInfoDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mainProduct[] = $item;
        return $this;
    }
}
