<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for srsProcessFvfCommissionType StructType
 * @subpackage Structs
 */
class SrsProcessFvfCommissionType extends AbstractStructBase
{
    /**
     * The revenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $revenue;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The fvfCommissionTypeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fvfCommissionTypeDescription;
    /**
     * Constructor method for srsProcessFvfCommissionType
     * @uses SrsProcessFvfCommissionType::setRevenue()
     * @uses SrsProcessFvfCommissionType::setRate()
     * @uses SrsProcessFvfCommissionType::setFvfCommissionTypeDescription()
     * @param float $revenue
     * @param float $rate
     * @param string $fvfCommissionTypeDescription
     */
    public function __construct($revenue = null, $rate = null, $fvfCommissionTypeDescription = null)
    {
        $this
            ->setRevenue($revenue)
            ->setRate($rate)
            ->setFvfCommissionTypeDescription($fvfCommissionTypeDescription);
    }
    /**
     * Get revenue value
     * @return float|null
     */
    public function getRevenue()
    {
        return $this->revenue;
    }
    /**
     * Set revenue value
     * @param float $revenue
     * @return \StructType\SrsProcessFvfCommissionType
     */
    public function setRevenue($revenue = null)
    {
        // validation for constraint: float
        if (!is_null($revenue) && !(is_float($revenue) || is_numeric($revenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($revenue, true), gettype($revenue)), __LINE__);
        }
        $this->revenue = $revenue;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\SrsProcessFvfCommissionType
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get fvfCommissionTypeDescription value
     * @return string|null
     */
    public function getFvfCommissionTypeDescription()
    {
        return $this->fvfCommissionTypeDescription;
    }
    /**
     * Set fvfCommissionTypeDescription value
     * @param string $fvfCommissionTypeDescription
     * @return \StructType\SrsProcessFvfCommissionType
     */
    public function setFvfCommissionTypeDescription($fvfCommissionTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fvfCommissionTypeDescription) && !is_string($fvfCommissionTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fvfCommissionTypeDescription, true), gettype($fvfCommissionTypeDescription)), __LINE__);
        }
        $this->fvfCommissionTypeDescription = $fvfCommissionTypeDescription;
        return $this;
    }
}
