<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleType StructType
 * @subpackage Structs
 */
class SaleType extends AbstractStructBase
{
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleCode;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The statusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusCode;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The productTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productTitle;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $price;
    /**
     * The cargoPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoPayment;
    /**
     * The cargoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoCode;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The buyerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrderBuyerInfoType
     */
    public $buyerInfo;
    /**
     * The changeStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $changeStatus;
    /**
     * The thumbImageLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thumbImageLink;
    /**
     * The lastActionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastActionDate;
    /**
     * The waitingProcesses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WaitingProcesses
     */
    public $waitingProcesses;
    /**
     * The invoiceInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleInvoiceType
     */
    public $invoiceInfo;
    /**
     * The variantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $variantId;
    /**
     * The variantSpecs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VariantSpecs
     */
    public $variantSpecs;
    /**
     * The moneyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $moneyDate;
    /**
     * The cargoApprovementDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoApprovementDate;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The shippingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShippingInfoType
     */
    public $shippingInfo;
    /**
     * The commissionRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $commissionRate;
    /**
     * Constructor method for saleType
     * @uses SaleType::setSaleCode()
     * @uses SaleType::setStatus()
     * @uses SaleType::setStatusCode()
     * @uses SaleType::setProductId()
     * @uses SaleType::setProductTitle()
     * @uses SaleType::setPrice()
     * @uses SaleType::setCargoPayment()
     * @uses SaleType::setCargoCode()
     * @uses SaleType::setAmount()
     * @uses SaleType::setEndDate()
     * @uses SaleType::setBuyerInfo()
     * @uses SaleType::setChangeStatus()
     * @uses SaleType::setThumbImageLink()
     * @uses SaleType::setLastActionDate()
     * @uses SaleType::setWaitingProcesses()
     * @uses SaleType::setInvoiceInfo()
     * @uses SaleType::setVariantId()
     * @uses SaleType::setVariantSpecs()
     * @uses SaleType::setMoneyDate()
     * @uses SaleType::setCargoApprovementDate()
     * @uses SaleType::setItemId()
     * @uses SaleType::setShippingInfo()
     * @uses SaleType::setCommissionRate()
     * @param string $saleCode
     * @param string $status
     * @param string $statusCode
     * @param int $productId
     * @param string $productTitle
     * @param string $price
     * @param string $cargoPayment
     * @param string $cargoCode
     * @param int $amount
     * @param string $endDate
     * @param \StructType\OrderBuyerInfoType $buyerInfo
     * @param string $changeStatus
     * @param string $thumbImageLink
     * @param string $lastActionDate
     * @param \StructType\WaitingProcesses $waitingProcesses
     * @param \StructType\SaleInvoiceType $invoiceInfo
     * @param int $variantId
     * @param \StructType\VariantSpecs $variantSpecs
     * @param string $moneyDate
     * @param string $cargoApprovementDate
     * @param string $itemId
     * @param \StructType\ShippingInfoType $shippingInfo
     * @param float $commissionRate
     */
    public function __construct($saleCode = null, $status = null, $statusCode = null, $productId = null, $productTitle = null, $price = null, $cargoPayment = null, $cargoCode = null, $amount = null, $endDate = null, \StructType\OrderBuyerInfoType $buyerInfo = null, $changeStatus = null, $thumbImageLink = null, $lastActionDate = null, \StructType\WaitingProcesses $waitingProcesses = null, \StructType\SaleInvoiceType $invoiceInfo = null, $variantId = null, \StructType\VariantSpecs $variantSpecs = null, $moneyDate = null, $cargoApprovementDate = null, $itemId = null, \StructType\ShippingInfoType $shippingInfo = null, $commissionRate = null)
    {
        $this
            ->setSaleCode($saleCode)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setProductId($productId)
            ->setProductTitle($productTitle)
            ->setPrice($price)
            ->setCargoPayment($cargoPayment)
            ->setCargoCode($cargoCode)
            ->setAmount($amount)
            ->setEndDate($endDate)
            ->setBuyerInfo($buyerInfo)
            ->setChangeStatus($changeStatus)
            ->setThumbImageLink($thumbImageLink)
            ->setLastActionDate($lastActionDate)
            ->setWaitingProcesses($waitingProcesses)
            ->setInvoiceInfo($invoiceInfo)
            ->setVariantId($variantId)
            ->setVariantSpecs($variantSpecs)
            ->setMoneyDate($moneyDate)
            ->setCargoApprovementDate($cargoApprovementDate)
            ->setItemId($itemId)
            ->setShippingInfo($shippingInfo)
            ->setCommissionRate($commissionRate);
    }
    /**
     * Get saleCode value
     * @return string|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * Set saleCode value
     * @param string $saleCode
     * @return \StructType\SaleType
     */
    public function setSaleCode($saleCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCode) && !is_string($saleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCode, true), gettype($saleCode)), __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\SaleType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param string $statusCode
     * @return \StructType\SaleType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\SaleType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productTitle value
     * @return string|null
     */
    public function getProductTitle()
    {
        return $this->productTitle;
    }
    /**
     * Set productTitle value
     * @param string $productTitle
     * @return \StructType\SaleType
     */
    public function setProductTitle($productTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTitle) && !is_string($productTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTitle, true), gettype($productTitle)), __LINE__);
        }
        $this->productTitle = $productTitle;
        return $this;
    }
    /**
     * Get price value
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \StructType\SaleType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get cargoPayment value
     * @return string|null
     */
    public function getCargoPayment()
    {
        return $this->cargoPayment;
    }
    /**
     * Set cargoPayment value
     * @param string $cargoPayment
     * @return \StructType\SaleType
     */
    public function setCargoPayment($cargoPayment = null)
    {
        // validation for constraint: string
        if (!is_null($cargoPayment) && !is_string($cargoPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoPayment, true), gettype($cargoPayment)), __LINE__);
        }
        $this->cargoPayment = $cargoPayment;
        return $this;
    }
    /**
     * Get cargoCode value
     * @return string|null
     */
    public function getCargoCode()
    {
        return $this->cargoCode;
    }
    /**
     * Set cargoCode value
     * @param string $cargoCode
     * @return \StructType\SaleType
     */
    public function setCargoCode($cargoCode = null)
    {
        // validation for constraint: string
        if (!is_null($cargoCode) && !is_string($cargoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoCode, true), gettype($cargoCode)), __LINE__);
        }
        $this->cargoCode = $cargoCode;
        return $this;
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\SaleType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\SaleType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get buyerInfo value
     * @return \StructType\OrderBuyerInfoType|null
     */
    public function getBuyerInfo()
    {
        return $this->buyerInfo;
    }
    /**
     * Set buyerInfo value
     * @param \StructType\OrderBuyerInfoType $buyerInfo
     * @return \StructType\SaleType
     */
    public function setBuyerInfo(\StructType\OrderBuyerInfoType $buyerInfo = null)
    {
        $this->buyerInfo = $buyerInfo;
        return $this;
    }
    /**
     * Get changeStatus value
     * @return string|null
     */
    public function getChangeStatus()
    {
        return $this->changeStatus;
    }
    /**
     * Set changeStatus value
     * @param string $changeStatus
     * @return \StructType\SaleType
     */
    public function setChangeStatus($changeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($changeStatus) && !is_string($changeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeStatus, true), gettype($changeStatus)), __LINE__);
        }
        $this->changeStatus = $changeStatus;
        return $this;
    }
    /**
     * Get thumbImageLink value
     * @return string|null
     */
    public function getThumbImageLink()
    {
        return $this->thumbImageLink;
    }
    /**
     * Set thumbImageLink value
     * @param string $thumbImageLink
     * @return \StructType\SaleType
     */
    public function setThumbImageLink($thumbImageLink = null)
    {
        // validation for constraint: string
        if (!is_null($thumbImageLink) && !is_string($thumbImageLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thumbImageLink, true), gettype($thumbImageLink)), __LINE__);
        }
        $this->thumbImageLink = $thumbImageLink;
        return $this;
    }
    /**
     * Get lastActionDate value
     * @return string|null
     */
    public function getLastActionDate()
    {
        return $this->lastActionDate;
    }
    /**
     * Set lastActionDate value
     * @param string $lastActionDate
     * @return \StructType\SaleType
     */
    public function setLastActionDate($lastActionDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastActionDate) && !is_string($lastActionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActionDate, true), gettype($lastActionDate)), __LINE__);
        }
        $this->lastActionDate = $lastActionDate;
        return $this;
    }
    /**
     * Get waitingProcesses value
     * @return \StructType\WaitingProcesses|null
     */
    public function getWaitingProcesses()
    {
        return $this->waitingProcesses;
    }
    /**
     * Set waitingProcesses value
     * @param \StructType\WaitingProcesses $waitingProcesses
     * @return \StructType\SaleType
     */
    public function setWaitingProcesses(\StructType\WaitingProcesses $waitingProcesses = null)
    {
        $this->waitingProcesses = $waitingProcesses;
        return $this;
    }
    /**
     * Get invoiceInfo value
     * @return \StructType\SaleInvoiceType|null
     */
    public function getInvoiceInfo()
    {
        return $this->invoiceInfo;
    }
    /**
     * Set invoiceInfo value
     * @param \StructType\SaleInvoiceType $invoiceInfo
     * @return \StructType\SaleType
     */
    public function setInvoiceInfo(\StructType\SaleInvoiceType $invoiceInfo = null)
    {
        $this->invoiceInfo = $invoiceInfo;
        return $this;
    }
    /**
     * Get variantId value
     * @return int|null
     */
    public function getVariantId()
    {
        return $this->variantId;
    }
    /**
     * Set variantId value
     * @param int $variantId
     * @return \StructType\SaleType
     */
    public function setVariantId($variantId = null)
    {
        // validation for constraint: int
        if (!is_null($variantId) && !(is_int($variantId) || ctype_digit($variantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($variantId, true), gettype($variantId)), __LINE__);
        }
        $this->variantId = $variantId;
        return $this;
    }
    /**
     * Get variantSpecs value
     * @return \StructType\VariantSpecs|null
     */
    public function getVariantSpecs()
    {
        return $this->variantSpecs;
    }
    /**
     * Set variantSpecs value
     * @param \StructType\VariantSpecs $variantSpecs
     * @return \StructType\SaleType
     */
    public function setVariantSpecs(\StructType\VariantSpecs $variantSpecs = null)
    {
        $this->variantSpecs = $variantSpecs;
        return $this;
    }
    /**
     * Get moneyDate value
     * @return string|null
     */
    public function getMoneyDate()
    {
        return $this->moneyDate;
    }
    /**
     * Set moneyDate value
     * @param string $moneyDate
     * @return \StructType\SaleType
     */
    public function setMoneyDate($moneyDate = null)
    {
        // validation for constraint: string
        if (!is_null($moneyDate) && !is_string($moneyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneyDate, true), gettype($moneyDate)), __LINE__);
        }
        $this->moneyDate = $moneyDate;
        return $this;
    }
    /**
     * Get cargoApprovementDate value
     * @return string|null
     */
    public function getCargoApprovementDate()
    {
        return $this->cargoApprovementDate;
    }
    /**
     * Set cargoApprovementDate value
     * @param string $cargoApprovementDate
     * @return \StructType\SaleType
     */
    public function setCargoApprovementDate($cargoApprovementDate = null)
    {
        // validation for constraint: string
        if (!is_null($cargoApprovementDate) && !is_string($cargoApprovementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoApprovementDate, true), gettype($cargoApprovementDate)), __LINE__);
        }
        $this->cargoApprovementDate = $cargoApprovementDate;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\SaleType
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get shippingInfo value
     * @return \StructType\ShippingInfoType|null
     */
    public function getShippingInfo()
    {
        return $this->shippingInfo;
    }
    /**
     * Set shippingInfo value
     * @param \StructType\ShippingInfoType $shippingInfo
     * @return \StructType\SaleType
     */
    public function setShippingInfo(\StructType\ShippingInfoType $shippingInfo = null)
    {
        $this->shippingInfo = $shippingInfo;
        return $this;
    }
    /**
     * Get commissionRate value
     * @return float|null
     */
    public function getCommissionRate()
    {
        return $this->commissionRate;
    }
    /**
     * Set commissionRate value
     * @param float $commissionRate
     * @return \StructType\SaleType
     */
    public function setCommissionRate($commissionRate = null)
    {
        // validation for constraint: float
        if (!is_null($commissionRate) && !(is_float($commissionRate) || is_numeric($commissionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionRate, true), gettype($commissionRate)), __LINE__);
        }
        $this->commissionRate = $commissionRate;
        return $this;
    }
}
