<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sellerPromotion StructType
 * @subpackage Structs
 */
class SellerPromotion extends AbstractStructBase
{
    /**
     * The basketLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $basketLimit;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The giftInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GiftInfoType
     */
    public $giftInfo;
    /**
     * The giftQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $giftQuantity;
    /**
     * The insertedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insertedAt;
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SellerPromotionItem[]
     */
    public $items;
    /**
     * The mainProductQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $mainProductQuantity;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The selectedGiftVariantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $selectedGiftVariantId;
    /**
     * The sellerIds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $sellerIds;
    /**
     * The sellerPromotionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sellerPromotionType;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The updatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updatedAt;
    /**
     * The usageLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $usageLimit;
    /**
     * Constructor method for sellerPromotion
     * @uses SellerPromotion::setBasketLimit()
     * @uses SellerPromotion::setEndDate()
     * @uses SellerPromotion::setGiftInfo()
     * @uses SellerPromotion::setGiftQuantity()
     * @uses SellerPromotion::setInsertedAt()
     * @uses SellerPromotion::setItems()
     * @uses SellerPromotion::setMainProductQuantity()
     * @uses SellerPromotion::setName()
     * @uses SellerPromotion::setSelectedGiftVariantId()
     * @uses SellerPromotion::setSellerIds()
     * @uses SellerPromotion::setSellerPromotionType()
     * @uses SellerPromotion::setStartDate()
     * @uses SellerPromotion::setStatus()
     * @uses SellerPromotion::setUpdatedAt()
     * @uses SellerPromotion::setUsageLimit()
     * @param int $basketLimit
     * @param string $endDate
     * @param \StructType\GiftInfoType $giftInfo
     * @param int $giftQuantity
     * @param string $insertedAt
     * @param \StructType\SellerPromotionItem[] $items
     * @param int $mainProductQuantity
     * @param string $name
     * @param int $selectedGiftVariantId
     * @param int[] $sellerIds
     * @param string $sellerPromotionType
     * @param string $startDate
     * @param string $status
     * @param string $updatedAt
     * @param int $usageLimit
     */
    public function __construct($basketLimit = null, $endDate = null, \StructType\GiftInfoType $giftInfo = null, $giftQuantity = null, $insertedAt = null, array $items = array(), $mainProductQuantity = null, $name = null, $selectedGiftVariantId = null, array $sellerIds = array(), $sellerPromotionType = null, $startDate = null, $status = null, $updatedAt = null, $usageLimit = null)
    {
        $this
            ->setBasketLimit($basketLimit)
            ->setEndDate($endDate)
            ->setGiftInfo($giftInfo)
            ->setGiftQuantity($giftQuantity)
            ->setInsertedAt($insertedAt)
            ->setItems($items)
            ->setMainProductQuantity($mainProductQuantity)
            ->setName($name)
            ->setSelectedGiftVariantId($selectedGiftVariantId)
            ->setSellerIds($sellerIds)
            ->setSellerPromotionType($sellerPromotionType)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setUpdatedAt($updatedAt)
            ->setUsageLimit($usageLimit);
    }
    /**
     * Get basketLimit value
     * @return int|null
     */
    public function getBasketLimit()
    {
        return $this->basketLimit;
    }
    /**
     * Set basketLimit value
     * @param int $basketLimit
     * @return \StructType\SellerPromotion
     */
    public function setBasketLimit($basketLimit = null)
    {
        // validation for constraint: int
        if (!is_null($basketLimit) && !(is_int($basketLimit) || ctype_digit($basketLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($basketLimit, true), gettype($basketLimit)), __LINE__);
        }
        $this->basketLimit = $basketLimit;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\SellerPromotion
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get giftInfo value
     * @return \StructType\GiftInfoType|null
     */
    public function getGiftInfo()
    {
        return $this->giftInfo;
    }
    /**
     * Set giftInfo value
     * @param \StructType\GiftInfoType $giftInfo
     * @return \StructType\SellerPromotion
     */
    public function setGiftInfo(\StructType\GiftInfoType $giftInfo = null)
    {
        $this->giftInfo = $giftInfo;
        return $this;
    }
    /**
     * Get giftQuantity value
     * @return int|null
     */
    public function getGiftQuantity()
    {
        return $this->giftQuantity;
    }
    /**
     * Set giftQuantity value
     * @param int $giftQuantity
     * @return \StructType\SellerPromotion
     */
    public function setGiftQuantity($giftQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($giftQuantity) && !(is_int($giftQuantity) || ctype_digit($giftQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($giftQuantity, true), gettype($giftQuantity)), __LINE__);
        }
        $this->giftQuantity = $giftQuantity;
        return $this;
    }
    /**
     * Get insertedAt value
     * @return string|null
     */
    public function getInsertedAt()
    {
        return $this->insertedAt;
    }
    /**
     * Set insertedAt value
     * @param string $insertedAt
     * @return \StructType\SellerPromotion
     */
    public function setInsertedAt($insertedAt = null)
    {
        // validation for constraint: string
        if (!is_null($insertedAt) && !is_string($insertedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertedAt, true), gettype($insertedAt)), __LINE__);
        }
        $this->insertedAt = $insertedAt;
        return $this;
    }
    /**
     * Get items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SellerPromotionItem[]|null
     */
    public function getItems()
    {
        return isset($this->items) ? $this->items : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sellerPromotionItemsItem) {
            // validation for constraint: itemType
            if (!$sellerPromotionItemsItem instanceof \StructType\SellerPromotionItem) {
                $invalidValues[] = is_object($sellerPromotionItemsItem) ? get_class($sellerPromotionItemsItem) : sprintf('%s(%s)', gettype($sellerPromotionItemsItem), var_export($sellerPromotionItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \StructType\SellerPromotionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SellerPromotionItem[] $items
     * @return \StructType\SellerPromotion
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->items);
        } else {
            $this->items = $items;
        }
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \StructType\SellerPromotionItem $item
     * @return \StructType\SellerPromotion
     */
    public function addToItems(\StructType\SellerPromotionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SellerPromotionItem) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \StructType\SellerPromotionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Get mainProductQuantity value
     * @return int|null
     */
    public function getMainProductQuantity()
    {
        return $this->mainProductQuantity;
    }
    /**
     * Set mainProductQuantity value
     * @param int $mainProductQuantity
     * @return \StructType\SellerPromotion
     */
    public function setMainProductQuantity($mainProductQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($mainProductQuantity) && !(is_int($mainProductQuantity) || ctype_digit($mainProductQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mainProductQuantity, true), gettype($mainProductQuantity)), __LINE__);
        }
        $this->mainProductQuantity = $mainProductQuantity;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SellerPromotion
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get selectedGiftVariantId value
     * @return int|null
     */
    public function getSelectedGiftVariantId()
    {
        return $this->selectedGiftVariantId;
    }
    /**
     * Set selectedGiftVariantId value
     * @param int $selectedGiftVariantId
     * @return \StructType\SellerPromotion
     */
    public function setSelectedGiftVariantId($selectedGiftVariantId = null)
    {
        // validation for constraint: int
        if (!is_null($selectedGiftVariantId) && !(is_int($selectedGiftVariantId) || ctype_digit($selectedGiftVariantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedGiftVariantId, true), gettype($selectedGiftVariantId)), __LINE__);
        }
        $this->selectedGiftVariantId = $selectedGiftVariantId;
        return $this;
    }
    /**
     * Get sellerIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getSellerIds()
    {
        return isset($this->sellerIds) ? $this->sellerIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSellerIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSellerIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSellerIdsForArrayConstraintsFromSetSellerIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sellerPromotionSellerIdsItem) {
            // validation for constraint: itemType
            if (!(is_int($sellerPromotionSellerIdsItem) || ctype_digit($sellerPromotionSellerIdsItem))) {
                $invalidValues[] = is_object($sellerPromotionSellerIdsItem) ? get_class($sellerPromotionSellerIdsItem) : sprintf('%s(%s)', gettype($sellerPromotionSellerIdsItem), var_export($sellerPromotionSellerIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sellerIds property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sellerIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $sellerIds
     * @return \StructType\SellerPromotion
     */
    public function setSellerIds(array $sellerIds = array())
    {
        // validation for constraint: array
        if ('' !== ($sellerIdsArrayErrorMessage = self::validateSellerIdsForArrayConstraintsFromSetSellerIds($sellerIds))) {
            throw new \InvalidArgumentException($sellerIdsArrayErrorMessage, __LINE__);
        }
        if (is_null($sellerIds) || (is_array($sellerIds) && empty($sellerIds))) {
            unset($this->sellerIds);
        } else {
            $this->sellerIds = $sellerIds;
        }
        return $this;
    }
    /**
     * Add item to sellerIds value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\SellerPromotion
     */
    public function addToSellerIds($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The sellerIds property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sellerIds[] = $item;
        return $this;
    }
    /**
     * Get sellerPromotionType value
     * @return string|null
     */
    public function getSellerPromotionType()
    {
        return $this->sellerPromotionType;
    }
    /**
     * Set sellerPromotionType value
     * @uses \EnumType\SellerPromotionType::valueIsValid()
     * @uses \EnumType\SellerPromotionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellerPromotionType
     * @return \StructType\SellerPromotion
     */
    public function setSellerPromotionType($sellerPromotionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SellerPromotionType::valueIsValid($sellerPromotionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SellerPromotionType', is_array($sellerPromotionType) ? implode(', ', $sellerPromotionType) : var_export($sellerPromotionType, true), implode(', ', \EnumType\SellerPromotionType::getValidValues())), __LINE__);
        }
        $this->sellerPromotionType = $sellerPromotionType;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\SellerPromotion
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\SellerPromotionStatusType::valueIsValid()
     * @uses \EnumType\SellerPromotionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SellerPromotion
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SellerPromotionStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SellerPromotionStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\SellerPromotionStatusType::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get updatedAt value
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
    /**
     * Set updatedAt value
     * @param string $updatedAt
     * @return \StructType\SellerPromotion
     */
    public function setUpdatedAt($updatedAt = null)
    {
        // validation for constraint: string
        if (!is_null($updatedAt) && !is_string($updatedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedAt, true), gettype($updatedAt)), __LINE__);
        }
        $this->updatedAt = $updatedAt;
        return $this;
    }
    /**
     * Get usageLimit value
     * @return int|null
     */
    public function getUsageLimit()
    {
        return $this->usageLimit;
    }
    /**
     * Set usageLimit value
     * @param int $usageLimit
     * @return \StructType\SellerPromotion
     */
    public function setUsageLimit($usageLimit = null)
    {
        // validation for constraint: int
        if (!is_null($usageLimit) && !(is_int($usageLimit) || ctype_digit($usageLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usageLimit, true), gettype($usageLimit)), __LINE__);
        }
        $this->usageLimit = $usageLimit;
        return $this;
    }
}
