<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleProcessReportV2Response StructType
 * @subpackage Structs
 */
class SaleProcessReportV2Response extends BaseResponse
{
    /**
     * The totalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalCount;
    /**
     * The sales
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaleProcessTypeV2[]
     */
    public $sales;
    /**
     * Constructor method for saleProcessReportV2Response
     * @uses SaleProcessReportV2Response::setTotalCount()
     * @uses SaleProcessReportV2Response::setSales()
     * @param int $totalCount
     * @param \StructType\SaleProcessTypeV2[] $sales
     */
    public function __construct($totalCount = null, array $sales = array())
    {
        $this
            ->setTotalCount($totalCount)
            ->setSales($sales);
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\SaleProcessReportV2Response
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get sales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaleProcessTypeV2[]|null
     */
    public function getSales()
    {
        return isset($this->sales) ? $this->sales : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSales method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSales method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesForArrayConstraintsFromSetSales(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $saleProcessReportV2ResponseSalesItem) {
            // validation for constraint: itemType
            if (!$saleProcessReportV2ResponseSalesItem instanceof \StructType\SaleProcessTypeV2) {
                $invalidValues[] = is_object($saleProcessReportV2ResponseSalesItem) ? get_class($saleProcessReportV2ResponseSalesItem) : sprintf('%s(%s)', gettype($saleProcessReportV2ResponseSalesItem), var_export($saleProcessReportV2ResponseSalesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sales property can only contain items of type \StructType\SaleProcessTypeV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SaleProcessTypeV2[] $sales
     * @return \StructType\SaleProcessReportV2Response
     */
    public function setSales(array $sales = array())
    {
        // validation for constraint: array
        if ('' !== ($salesArrayErrorMessage = self::validateSalesForArrayConstraintsFromSetSales($sales))) {
            throw new \InvalidArgumentException($salesArrayErrorMessage, __LINE__);
        }
        if (is_null($sales) || (is_array($sales) && empty($sales))) {
            unset($this->sales);
        } else {
            $this->sales = $sales;
        }
        return $this;
    }
    /**
     * Add item to sales value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleProcessTypeV2 $item
     * @return \StructType\SaleProcessReportV2Response
     */
    public function addToSales(\StructType\SaleProcessTypeV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleProcessTypeV2) {
            throw new \InvalidArgumentException(sprintf('The sales property can only contain items of type \StructType\SaleProcessTypeV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sales[] = $item;
        return $this;
    }
}
