<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for baseResponse StructType
 * @subpackage Structs
 */
class BaseResponse extends AbstractStructBase
{
    /**
     * The ackCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ackCode;
    /**
     * The responseTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $responseTime;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorType_1
     */
    public $error;
    /**
     * The timeElapsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeElapsed;
    /**
     * Constructor method for baseResponse
     * @uses BaseResponse::setAckCode()
     * @uses BaseResponse::setResponseTime()
     * @uses BaseResponse::setError()
     * @uses BaseResponse::setTimeElapsed()
     * @param string $ackCode
     * @param string $responseTime
     * @param \StructType\ErrorType_1 $error
     * @param string $timeElapsed
     */
    public function __construct($ackCode = null, $responseTime = null, \StructType\ErrorType_1 $error = null, $timeElapsed = null)
    {
        $this
            ->setAckCode($ackCode)
            ->setResponseTime($responseTime)
            ->setError($error)
            ->setTimeElapsed($timeElapsed);
    }
    /**
     * Get ackCode value
     * @return string|null
     */
    public function getAckCode()
    {
        return $this->ackCode;
    }
    /**
     * Set ackCode value
     * @param string $ackCode
     * @return \StructType\BaseResponse
     */
    public function setAckCode($ackCode = null)
    {
        // validation for constraint: string
        if (!is_null($ackCode) && !is_string($ackCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ackCode, true), gettype($ackCode)), __LINE__);
        }
        $this->ackCode = $ackCode;
        return $this;
    }
    /**
     * Get responseTime value
     * @return string|null
     */
    public function getResponseTime()
    {
        return $this->responseTime;
    }
    /**
     * Set responseTime value
     * @param string $responseTime
     * @return \StructType\BaseResponse
     */
    public function setResponseTime($responseTime = null)
    {
        // validation for constraint: string
        if (!is_null($responseTime) && !is_string($responseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseTime, true), gettype($responseTime)), __LINE__);
        }
        $this->responseTime = $responseTime;
        return $this;
    }
    /**
     * Get error value
     * @return \StructType\ErrorType_1|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\ErrorType_1 $error
     * @return \StructType\BaseResponse
     */
    public function setError(\StructType\ErrorType_1 $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get timeElapsed value
     * @return string|null
     */
    public function getTimeElapsed()
    {
        return $this->timeElapsed;
    }
    /**
     * Set timeElapsed value
     * @param string $timeElapsed
     * @return \StructType\BaseResponse
     */
    public function setTimeElapsed($timeElapsed = null)
    {
        // validation for constraint: string
        if (!is_null($timeElapsed) && !is_string($timeElapsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeElapsed, true), gettype($timeElapsed)), __LINE__);
        }
        $this->timeElapsed = $timeElapsed;
        return $this;
    }
}
