<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAccountTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startDate
     * @param string $endDate
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\AccountTransactionListResponse|bool
     */
    public function getAccountTransactions($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountTransactions($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountTransactionsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startDate
     * @param string $endDate
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\AccountTransactionListV2Response|bool
     */
    public function getAccountTransactionsV2($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountTransactionsV2($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountTransactionsV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startDate
     * @param string $endDate
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\AccountTransactionListV3Response|bool
     */
    public function getAccountTransactionsV3($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountTransactionsV3($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getItemBuyers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $byStatus
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\SaleServiceBuyerResponse|bool
     */
    public function getItemBuyers($apiKey, $sign, $time, $byStatus, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getItemBuyers($apiKey, $sign, $time, $byStatus, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPagedSales
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $withData
     * @param string $byStatus
     * @param string $byUser
     * @param string $orderBy
     * @param string $orderType
     * @param string $pageNumber
     * @param string $pageSize
     * @param string $lang
     * @return \StructType\SaleServicePagingResponse|bool
     */
    public function getPagedSales($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $pageNumber, $pageSize, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getPagedSales($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $pageNumber, $pageSize, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPagedSalesByDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $withData
     * @param string $byStatus
     * @param string $byUser
     * @param string $orderBy
     * @param string $orderType
     * @param string $startDate
     * @param string $endDate
     * @param string $pageNumber
     * @param string $pageSize
     * @param string $lang
     * @return \StructType\SaleServicePagingResponse|bool
     */
    public function getPagedSalesByDateRange($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $startDate, $endDate, $pageNumber, $pageSize, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getPagedSalesByDateRange($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $startDate, $endDate, $pageNumber, $pageSize, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReasonsToCancelSale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $lang
     * @return \StructType\SaleServiceCancelReasonResponse|bool
     */
    public function getReasonsToCancelSale($apiKey, $sign, $time, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getReasonsToCancelSale($apiKey, $sign, $time, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $lang
     * @return \StructType\SaleServiceResponse|bool
     */
    public function getSale($apiKey, $sign, $time, $saleCode, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getSale($apiKey, $sign, $time, $saleCode, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSaleProcessReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startDate
     * @param string $endDate
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\SaleProcessReportResponse|bool
     */
    public function getSaleProcessReport($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getSaleProcessReport($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSaleProcessReportV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startDate
     * @param string $endDate
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\SaleProcessReportV2Response|bool
     */
    public function getSaleProcessReportV2($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getSaleProcessReportV2($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSales
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $withData
     * @param string $byStatus
     * @param string $byUser
     * @param string $orderBy
     * @param string $orderType
     * @param string $pageNumber
     * @param string $pageSize
     * @param string $lang
     * @return \StructType\SaleServicePagingResponse|bool
     */
    public function getSales($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $pageNumber, $pageSize, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getSales($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $pageNumber, $pageSize, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSalesByDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $withData
     * @param string $byStatus
     * @param string $byUser
     * @param string $orderBy
     * @param string $orderType
     * @param string $startDate
     * @param string $endDate
     * @param string $pageNumber
     * @param string $pageSize
     * @param string $lang
     * @return \StructType\SaleServicePagingResponse|bool
     */
    public function getSalesByDateRange($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $startDate, $endDate, $pageNumber, $pageSize, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getSalesByDateRange($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $startDate, $endDate, $pageNumber, $pageSize, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getServiceName()
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceName());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\AccountTransactionListResponse|\StructType\AccountTransactionListV2Response|\StructType\AccountTransactionListV3Response|\StructType\SaleProcessReportResponse|\StructType\SaleProcessReportV2Response|\StructType\SaleServiceBuyerResponse|\StructType\SaleServiceCancelReasonResponse|\StructType\SaleServicePagingResponse|\StructType\SaleServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
