<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantSpecDto StructType
 * @subpackage Structs
 */
class VariantSpecDto extends AbstractStructBase
{
    /**
     * The soldQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $soldQuantity;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The stockCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stockCode;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $order;
    /**
     * The specDataId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $specDataId;
    /**
     * The specId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $specId;
    /**
     * Constructor method for variantSpecDto
     * @uses VariantSpecDto::setSoldQuantity()
     * @uses VariantSpecDto::setQuantity()
     * @uses VariantSpecDto::setName()
     * @uses VariantSpecDto::setValue()
     * @uses VariantSpecDto::setStockCode()
     * @uses VariantSpecDto::setOrder()
     * @uses VariantSpecDto::setSpecDataId()
     * @uses VariantSpecDto::setSpecId()
     * @param int $soldQuantity
     * @param int $quantity
     * @param string $name
     * @param string $value
     * @param string $stockCode
     * @param int $order
     * @param int $specDataId
     * @param int $specId
     */
    public function __construct($soldQuantity = null, $quantity = null, $name = null, $value = null, $stockCode = null, $order = null, $specDataId = null, $specId = null)
    {
        $this
            ->setSoldQuantity($soldQuantity)
            ->setQuantity($quantity)
            ->setName($name)
            ->setValue($value)
            ->setStockCode($stockCode)
            ->setOrder($order)
            ->setSpecDataId($specDataId)
            ->setSpecId($specId);
    }
    /**
     * Get soldQuantity value
     * @return int|null
     */
    public function getSoldQuantity()
    {
        return $this->soldQuantity;
    }
    /**
     * Set soldQuantity value
     * @param int $soldQuantity
     * @return \StructType\VariantSpecDto
     */
    public function setSoldQuantity($soldQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($soldQuantity) && !(is_int($soldQuantity) || ctype_digit($soldQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldQuantity, true), gettype($soldQuantity)), __LINE__);
        }
        $this->soldQuantity = $soldQuantity;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\VariantSpecDto
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\VariantSpecDto
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\VariantSpecDto
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get stockCode value
     * @return string|null
     */
    public function getStockCode()
    {
        return $this->stockCode;
    }
    /**
     * Set stockCode value
     * @param string $stockCode
     * @return \StructType\VariantSpecDto
     */
    public function setStockCode($stockCode = null)
    {
        // validation for constraint: string
        if (!is_null($stockCode) && !is_string($stockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockCode, true), gettype($stockCode)), __LINE__);
        }
        $this->stockCode = $stockCode;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \StructType\VariantSpecDto
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get specDataId value
     * @return int|null
     */
    public function getSpecDataId()
    {
        return $this->specDataId;
    }
    /**
     * Set specDataId value
     * @param int $specDataId
     * @return \StructType\VariantSpecDto
     */
    public function setSpecDataId($specDataId = null)
    {
        // validation for constraint: int
        if (!is_null($specDataId) && !(is_int($specDataId) || ctype_digit($specDataId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($specDataId, true), gettype($specDataId)), __LINE__);
        }
        $this->specDataId = $specDataId;
        return $this;
    }
    /**
     * Get specId value
     * @return int|null
     */
    public function getSpecId()
    {
        return $this->specId;
    }
    /**
     * Set specId value
     * @param int $specId
     * @return \StructType\VariantSpecDto
     */
    public function setSpecId($specId = null)
    {
        // validation for constraint: int
        if (!is_null($specId) && !(is_int($specId) || ctype_digit($specId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($specId, true), gettype($specId)), __LINE__);
        }
        $this->specId = $specId;
        return $this;
    }
}
