<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderBuyerInfoType StructType
 * @subpackage Structs
 */
class OrderBuyerInfoType extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The surname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The mobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The district
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $district;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The neighborhoodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NeighborhoodType
     */
    public $neighborhoodType;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The processCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $processCount;
    /**
     * The ratePercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ratePercentage;
    /**
     * Constructor method for orderBuyerInfoType
     * @uses OrderBuyerInfoType::setUsername()
     * @uses OrderBuyerInfoType::setName()
     * @uses OrderBuyerInfoType::setSurname()
     * @uses OrderBuyerInfoType::setPhone()
     * @uses OrderBuyerInfoType::setMobilePhone()
     * @uses OrderBuyerInfoType::setEmail()
     * @uses OrderBuyerInfoType::setAddress()
     * @uses OrderBuyerInfoType::setDistrict()
     * @uses OrderBuyerInfoType::setCity()
     * @uses OrderBuyerInfoType::setNeighborhoodType()
     * @uses OrderBuyerInfoType::setZipCode()
     * @uses OrderBuyerInfoType::setProcessCount()
     * @uses OrderBuyerInfoType::setRatePercentage()
     * @param string $username
     * @param string $name
     * @param string $surname
     * @param string $phone
     * @param string $mobilePhone
     * @param string $email
     * @param string $address
     * @param string $district
     * @param string $city
     * @param \StructType\NeighborhoodType $neighborhoodType
     * @param string $zipCode
     * @param int $processCount
     * @param int $ratePercentage
     */
    public function __construct($username = null, $name = null, $surname = null, $phone = null, $mobilePhone = null, $email = null, $address = null, $district = null, $city = null, \StructType\NeighborhoodType $neighborhoodType = null, $zipCode = null, $processCount = null, $ratePercentage = null)
    {
        $this
            ->setUsername($username)
            ->setName($name)
            ->setSurname($surname)
            ->setPhone($phone)
            ->setMobilePhone($mobilePhone)
            ->setEmail($email)
            ->setAddress($address)
            ->setDistrict($district)
            ->setCity($city)
            ->setNeighborhoodType($neighborhoodType)
            ->setZipCode($zipCode)
            ->setProcessCount($processCount)
            ->setRatePercentage($ratePercentage);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\OrderBuyerInfoType
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OrderBuyerInfoType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\OrderBuyerInfoType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\OrderBuyerInfoType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \StructType\OrderBuyerInfoType
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\OrderBuyerInfoType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\OrderBuyerInfoType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\OrderBuyerInfoType
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\OrderBuyerInfoType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get neighborhoodType value
     * @return \StructType\NeighborhoodType|null
     */
    public function getNeighborhoodType()
    {
        return $this->neighborhoodType;
    }
    /**
     * Set neighborhoodType value
     * @param \StructType\NeighborhoodType $neighborhoodType
     * @return \StructType\OrderBuyerInfoType
     */
    public function setNeighborhoodType(\StructType\NeighborhoodType $neighborhoodType = null)
    {
        $this->neighborhoodType = $neighborhoodType;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\OrderBuyerInfoType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get processCount value
     * @return int|null
     */
    public function getProcessCount()
    {
        return $this->processCount;
    }
    /**
     * Set processCount value
     * @param int $processCount
     * @return \StructType\OrderBuyerInfoType
     */
    public function setProcessCount($processCount = null)
    {
        // validation for constraint: int
        if (!is_null($processCount) && !(is_int($processCount) || ctype_digit($processCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processCount, true), gettype($processCount)), __LINE__);
        }
        $this->processCount = $processCount;
        return $this;
    }
    /**
     * Get ratePercentage value
     * @return int|null
     */
    public function getRatePercentage()
    {
        return $this->ratePercentage;
    }
    /**
     * Set ratePercentage value
     * @param int $ratePercentage
     * @return \StructType\OrderBuyerInfoType
     */
    public function setRatePercentage($ratePercentage = null)
    {
        // validation for constraint: int
        if (!is_null($ratePercentage) && !(is_int($ratePercentage) || ctype_digit($ratePercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ratePercentage, true), gettype($ratePercentage)), __LINE__);
        }
        $this->ratePercentage = $ratePercentage;
        return $this;
    }
}
